/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.transform.SerDeInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SerDeInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, SerDeInfo> {
    private final String name;
    private final String serializationLibrary;
    private final Map<String, String> parameters;

    private SerDeInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.serializationLibrary = builder.serializationLibrary;
        this.parameters = builder.parameters;
    }

    public String name() {
        return this.name;
    }

    public String serializationLibrary() {
        return this.serializationLibrary;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serializationLibrary());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SerDeInfo)) {
            return false;
        }
        SerDeInfo other = (SerDeInfo)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.serializationLibrary(), other.serializationLibrary()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"SerDeInfo").add("Name", (Object)this.name()).add("SerializationLibrary", (Object)this.serializationLibrary()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SerializationLibrary": {
                return Optional.of(clazz.cast(this.serializationLibrary()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SerDeInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String serializationLibrary;
        private Map<String, String> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SerDeInfo model) {
            this.name(model.name);
            this.serializationLibrary(model.serializationLibrary);
            this.parameters(model.parameters);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSerializationLibrary() {
            return this.serializationLibrary;
        }

        @Override
        public final Builder serializationLibrary(String serializationLibrary) {
            this.serializationLibrary = serializationLibrary;
            return this;
        }

        public final void setSerializationLibrary(String serializationLibrary) {
            this.serializationLibrary = serializationLibrary;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public SerDeInfo build() {
            return new SerDeInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SerDeInfo> {
        public Builder name(String var1);

        public Builder serializationLibrary(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

