/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.SegmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Segment
implements StructuredPojo,
ToCopyableBuilder<Builder, Segment> {
    private final Integer segmentNumber;
    private final Integer totalSegments;

    private Segment(BuilderImpl builder) {
        this.segmentNumber = builder.segmentNumber;
        this.totalSegments = builder.totalSegments;
    }

    public Integer segmentNumber() {
        return this.segmentNumber;
    }

    public Integer totalSegments() {
        return this.totalSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSegments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)obj;
        return Objects.equals(this.segmentNumber(), other.segmentNumber()) && Objects.equals(this.totalSegments(), other.totalSegments());
    }

    public String toString() {
        return ToString.builder((String)"Segment").add("SegmentNumber", (Object)this.segmentNumber()).add("TotalSegments", (Object)this.totalSegments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentNumber": {
                return Optional.of(clazz.cast(this.segmentNumber()));
            }
            case "TotalSegments": {
                return Optional.of(clazz.cast(this.totalSegments()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer segmentNumber;
        private Integer totalSegments;

        private BuilderImpl() {
        }

        private BuilderImpl(Segment model) {
            this.segmentNumber(model.segmentNumber);
            this.totalSegments(model.totalSegments);
        }

        public final Integer getSegmentNumber() {
            return this.segmentNumber;
        }

        @Override
        public final Builder segmentNumber(Integer segmentNumber) {
            this.segmentNumber = segmentNumber;
            return this;
        }

        public final void setSegmentNumber(Integer segmentNumber) {
            this.segmentNumber = segmentNumber;
        }

        public final Integer getTotalSegments() {
            return this.totalSegments;
        }

        @Override
        public final Builder totalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
            return this;
        }

        public final void setTotalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
        }

        public Segment build() {
            return new Segment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Segment> {
        public Builder segmentNumber(Integer var1);

        public Builder totalSegments(Integer var1);
    }
}

