/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.PredecessorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Predecessor
implements StructuredPojo,
ToCopyableBuilder<Builder, Predecessor> {
    private final String jobName;
    private final String runId;

    private Predecessor(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.runId = builder.runId;
    }

    public String jobName() {
        return this.jobName;
    }

    public String runId() {
        return this.runId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predecessor)) {
            return false;
        }
        Predecessor other = (Predecessor)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.runId(), other.runId());
    }

    public String toString() {
        return ToString.builder((String)"Predecessor").add("JobName", (Object)this.jobName()).add("RunId", (Object)this.runId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "RunId": {
                return Optional.of(clazz.cast(this.runId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredecessorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(Predecessor model) {
            this.jobName(model.jobName);
            this.runId(model.runId);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getRunId() {
            return this.runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public Predecessor build() {
            return new Predecessor(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Predecessor> {
        public Builder jobName(String var1);

        public Builder runId(String var1);
    }
}

