/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.JobRunState;
import software.amazon.awssdk.services.glue.model.Predecessor;
import software.amazon.awssdk.services.glue.model.PredecessorListCopier;
import software.amazon.awssdk.services.glue.transform.JobRunMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobRun
implements StructuredPojo,
ToCopyableBuilder<Builder, JobRun> {
    private final String id;
    private final Integer attempt;
    private final String previousRunId;
    private final String triggerName;
    private final String jobName;
    private final Instant startedOn;
    private final Instant lastModifiedOn;
    private final Instant completedOn;
    private final String jobRunState;
    private final Map<String, String> arguments;
    private final String errorMessage;
    private final List<Predecessor> predecessorRuns;
    private final Integer allocatedCapacity;

    private JobRun(BuilderImpl builder) {
        this.id = builder.id;
        this.attempt = builder.attempt;
        this.previousRunId = builder.previousRunId;
        this.triggerName = builder.triggerName;
        this.jobName = builder.jobName;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.jobRunState = builder.jobRunState;
        this.arguments = builder.arguments;
        this.errorMessage = builder.errorMessage;
        this.predecessorRuns = builder.predecessorRuns;
        this.allocatedCapacity = builder.allocatedCapacity;
    }

    public String id() {
        return this.id;
    }

    public Integer attempt() {
        return this.attempt;
    }

    public String previousRunId() {
        return this.previousRunId;
    }

    public String triggerName() {
        return this.triggerName;
    }

    public String jobName() {
        return this.jobName;
    }

    public Instant startedOn() {
        return this.startedOn;
    }

    public Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public Instant completedOn() {
        return this.completedOn;
    }

    public JobRunState jobRunState() {
        return JobRunState.fromValue(this.jobRunState);
    }

    public String jobRunStateAsString() {
        return this.jobRunState;
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<Predecessor> predecessorRuns() {
        return this.predecessorRuns;
    }

    public Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arguments());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.predecessorRuns());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.attempt(), other.attempt()) && Objects.equals(this.previousRunId(), other.previousRunId()) && Objects.equals(this.triggerName(), other.triggerName()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.jobRunStateAsString(), other.jobRunStateAsString()) && Objects.equals(this.arguments(), other.arguments()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.predecessorRuns(), other.predecessorRuns()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity());
    }

    public String toString() {
        return ToString.builder((String)"JobRun").add("Id", (Object)this.id()).add("Attempt", (Object)this.attempt()).add("PreviousRunId", (Object)this.previousRunId()).add("TriggerName", (Object)this.triggerName()).add("JobName", (Object)this.jobName()).add("StartedOn", (Object)this.startedOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("CompletedOn", (Object)this.completedOn()).add("JobRunState", (Object)this.jobRunStateAsString()).add("Arguments", this.arguments()).add("ErrorMessage", (Object)this.errorMessage()).add("PredecessorRuns", this.predecessorRuns()).add("AllocatedCapacity", (Object)this.allocatedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Attempt": {
                return Optional.of(clazz.cast(this.attempt()));
            }
            case "PreviousRunId": {
                return Optional.of(clazz.cast(this.previousRunId()));
            }
            case "TriggerName": {
                return Optional.of(clazz.cast(this.triggerName()));
            }
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "StartedOn": {
                return Optional.of(clazz.cast(this.startedOn()));
            }
            case "LastModifiedOn": {
                return Optional.of(clazz.cast(this.lastModifiedOn()));
            }
            case "CompletedOn": {
                return Optional.of(clazz.cast(this.completedOn()));
            }
            case "JobRunState": {
                return Optional.of(clazz.cast(this.jobRunStateAsString()));
            }
            case "Arguments": {
                return Optional.of(clazz.cast(this.arguments()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
            case "PredecessorRuns": {
                return Optional.of(clazz.cast(this.predecessorRuns()));
            }
            case "AllocatedCapacity": {
                return Optional.of(clazz.cast(this.allocatedCapacity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobRunMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Integer attempt;
        private String previousRunId;
        private String triggerName;
        private String jobName;
        private Instant startedOn;
        private Instant lastModifiedOn;
        private Instant completedOn;
        private String jobRunState;
        private Map<String, String> arguments;
        private String errorMessage;
        private List<Predecessor> predecessorRuns;
        private Integer allocatedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRun model) {
            this.id(model.id);
            this.attempt(model.attempt);
            this.previousRunId(model.previousRunId);
            this.triggerName(model.triggerName);
            this.jobName(model.jobName);
            this.startedOn(model.startedOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.completedOn(model.completedOn);
            this.jobRunState(model.jobRunState);
            this.arguments(model.arguments);
            this.errorMessage(model.errorMessage);
            this.predecessorRuns(model.predecessorRuns);
            this.allocatedCapacity(model.allocatedCapacity);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        public final String getPreviousRunId() {
            return this.previousRunId;
        }

        @Override
        public final Builder previousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
            return this;
        }

        public final void setPreviousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
        }

        public final String getTriggerName() {
            return this.triggerName;
        }

        @Override
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        public final String getJobRunState() {
            return this.jobRunState;
        }

        @Override
        public final Builder jobRunState(String jobRunState) {
            this.jobRunState = jobRunState;
            return this;
        }

        @Override
        public final Builder jobRunState(JobRunState jobRunState) {
            this.jobRunState(jobRunState.toString());
            return this;
        }

        public final void setJobRunState(String jobRunState) {
            this.jobRunState = jobRunState;
        }

        public final Map<String, String> getArguments() {
            return this.arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<Predecessor.Builder> getPredecessorRuns() {
            return this.predecessorRuns != null ? (Collection)this.predecessorRuns.stream().map(Predecessor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder predecessorRuns(Collection<Predecessor> predecessorRuns) {
            this.predecessorRuns = PredecessorListCopier.copy(predecessorRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predecessorRuns(Predecessor ... predecessorRuns) {
            this.predecessorRuns(Arrays.asList(predecessorRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predecessorRuns(Consumer<Predecessor.Builder> ... predecessorRuns) {
            this.predecessorRuns(Stream.of(predecessorRuns).map(c -> (Predecessor)((Predecessor.Builder)Predecessor.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPredecessorRuns(Collection<Predecessor.BuilderImpl> predecessorRuns) {
            this.predecessorRuns = PredecessorListCopier.copyFromBuilder(predecessorRuns);
        }

        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        public JobRun build() {
            return new JobRun(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobRun> {
        public Builder id(String var1);

        public Builder attempt(Integer var1);

        public Builder previousRunId(String var1);

        public Builder triggerName(String var1);

        public Builder jobName(String var1);

        public Builder startedOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder jobRunState(String var1);

        public Builder jobRunState(JobRunState var1);

        public Builder arguments(Map<String, String> var1);

        public Builder errorMessage(String var1);

        public Builder predecessorRuns(Collection<Predecessor> var1);

        public Builder predecessorRuns(Predecessor ... var1);

        public Builder predecessorRuns(Consumer<Predecessor.Builder> ... var1);

        public Builder allocatedCapacity(Integer var1);
    }
}

