/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DatabaseListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDatabasesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDatabasesResponse> {
    private final List<Database> databaseList;
    private final String nextToken;

    private GetDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.databaseList = builder.databaseList;
        this.nextToken = builder.nextToken;
    }

    public List<Database> databaseList() {
        return this.databaseList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabasesResponse)) {
            return false;
        }
        GetDatabasesResponse other = (GetDatabasesResponse)((Object)obj);
        return Objects.equals(this.databaseList(), other.databaseList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetDatabasesResponse").add("DatabaseList", this.databaseList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseList": {
                return Optional.of(clazz.cast(this.databaseList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Database> databaseList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabasesResponse model) {
            super(model);
            this.databaseList(model.databaseList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Database.Builder> getDatabaseList() {
            return this.databaseList != null ? (Collection)this.databaseList.stream().map(Database::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder databaseList(Collection<Database> databaseList) {
            this.databaseList = DatabaseListCopier.copy(databaseList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(Database ... databaseList) {
            this.databaseList(Arrays.asList(databaseList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(Consumer<Database.Builder> ... databaseList) {
            this.databaseList(Stream.of(databaseList).map(c -> (Database)((Database.Builder)Database.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatabaseList(Collection<Database.BuilderImpl> databaseList) {
            this.databaseList = DatabaseListCopier.copyFromBuilder(databaseList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDatabasesResponse build() {
            return new GetDatabasesResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetDatabasesResponse> {
        public Builder databaseList(Collection<Database> var1);

        public Builder databaseList(Database ... var1);

        public Builder databaseList(Consumer<Database.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

