/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.glue.model.Crawler;
import software.amazon.awssdk.services.glue.model.CrawlerListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCrawlersResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetCrawlersResponse> {
    private final List<Crawler> crawlers;
    private final String nextToken;

    private GetCrawlersResponse(BuilderImpl builder) {
        super(builder);
        this.crawlers = builder.crawlers;
        this.nextToken = builder.nextToken;
    }

    public List<Crawler> crawlers() {
        return this.crawlers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCrawlersResponse)) {
            return false;
        }
        GetCrawlersResponse other = (GetCrawlersResponse)((Object)obj);
        return Objects.equals(this.crawlers(), other.crawlers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetCrawlersResponse").add("Crawlers", this.crawlers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Crawlers": {
                return Optional.of(clazz.cast(this.crawlers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Crawler> crawlers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCrawlersResponse model) {
            super(model);
            this.crawlers(model.crawlers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Crawler.Builder> getCrawlers() {
            return this.crawlers != null ? (Collection)this.crawlers.stream().map(Crawler::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder crawlers(Collection<Crawler> crawlers) {
            this.crawlers = CrawlerListCopier.copy(crawlers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlers(Crawler ... crawlers) {
            this.crawlers(Arrays.asList(crawlers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlers(Consumer<Crawler.Builder> ... crawlers) {
            this.crawlers(Stream.of(crawlers).map(c -> (Crawler)((Crawler.Builder)Crawler.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCrawlers(Collection<Crawler.BuilderImpl> crawlers) {
            this.crawlers = CrawlerListCopier.copyFromBuilder(crawlers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetCrawlersResponse build() {
            return new GetCrawlersResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetCrawlersResponse> {
        public Builder crawlers(Collection<Crawler> var1);

        public Builder crawlers(Crawler ... var1);

        public Builder crawlers(Consumer<Crawler.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

