/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.UserDefinedFunctionInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateUserDefinedFunctionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateUserDefinedFunctionRequest> {
    private final String catalogId;
    private final String databaseName;
    private final UserDefinedFunctionInput functionInput;

    private CreateUserDefinedFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.functionInput = builder.functionInput;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public UserDefinedFunctionInput functionInput() {
        return this.functionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionInput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserDefinedFunctionRequest)) {
            return false;
        }
        CreateUserDefinedFunctionRequest other = (CreateUserDefinedFunctionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.functionInput(), other.functionInput());
    }

    public String toString() {
        return ToString.builder((String)"CreateUserDefinedFunctionRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("FunctionInput", (Object)this.functionInput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "FunctionInput": {
                return Optional.of(clazz.cast(this.functionInput()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private UserDefinedFunctionInput functionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserDefinedFunctionRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.functionInput(model.functionInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final UserDefinedFunctionInput.Builder getFunctionInput() {
            return this.functionInput != null ? this.functionInput.toBuilder() : null;
        }

        @Override
        public final Builder functionInput(UserDefinedFunctionInput functionInput) {
            this.functionInput = functionInput;
            return this;
        }

        public final void setFunctionInput(UserDefinedFunctionInput.BuilderImpl functionInput) {
            this.functionInput = functionInput != null ? functionInput.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateUserDefinedFunctionRequest build() {
            return new CreateUserDefinedFunctionRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, CreateUserDefinedFunctionRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder functionInput(UserDefinedFunctionInput var1);

        default public Builder functionInput(Consumer<UserDefinedFunctionInput.Builder> functionInput) {
            return this.functionInput((UserDefinedFunctionInput)((UserDefinedFunctionInput.Builder)UserDefinedFunctionInput.builder().apply(functionInput)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

