/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.Action;
import software.amazon.awssdk.services.glue.model.ActionListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.Predicate;
import software.amazon.awssdk.services.glue.model.TriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTriggerRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateTriggerRequest> {
    private final String name;
    private final String type;
    private final String schedule;
    private final Predicate predicate;
    private final List<Action> actions;
    private final String description;

    private CreateTriggerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.schedule = builder.schedule;
        this.predicate = builder.predicate;
        this.actions = builder.actions;
        this.description = builder.description;
    }

    public String name() {
        return this.name;
    }

    public TriggerType type() {
        return TriggerType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String schedule() {
        return this.schedule;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.predicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTriggerRequest)) {
            return false;
        }
        CreateTriggerRequest other = (CreateTriggerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.predicate(), other.predicate()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"CreateTriggerRequest").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Schedule", (Object)this.schedule()).add("Predicate", (Object)this.predicate()).add("Actions", this.actions()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "Predicate": {
                return Optional.of(clazz.cast(this.predicate()));
            }
            case "Actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String schedule;
        private Predicate predicate;
        private List<Action> actions;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTriggerRequest model) {
            super(model);
            this.name(model.name);
            this.type(model.type);
            this.schedule(model.schedule);
            this.predicate(model.predicate);
            this.actions(model.actions);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TriggerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Predicate.Builder getPredicate() {
            return this.predicate != null ? this.predicate.toBuilder() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        public final Collection<Action.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateTriggerRequest build() {
            return new CreateTriggerRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, CreateTriggerRequest> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TriggerType var1);

        public Builder schedule(String var1);

        public Builder predicate(Predicate var1);

        default public Builder predicate(Consumer<Predicate.Builder> predicate) {
            return this.predicate((Predicate)((Predicate.Builder)Predicate.builder().apply(predicate)).build());
        }

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder description(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

