/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.CreateGrokClassifierRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGrokClassifierRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, CreateGrokClassifierRequest> {
    private final String classification;
    private final String name;
    private final String grokPattern;
    private final String customPatterns;

    private CreateGrokClassifierRequest(BuilderImpl builder) {
        this.classification = builder.classification;
        this.name = builder.name;
        this.grokPattern = builder.grokPattern;
        this.customPatterns = builder.customPatterns;
    }

    public String classification() {
        return this.classification;
    }

    public String name() {
        return this.name;
    }

    public String grokPattern() {
        return this.grokPattern;
    }

    public String customPatterns() {
        return this.customPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.grokPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPatterns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrokClassifierRequest)) {
            return false;
        }
        CreateGrokClassifierRequest other = (CreateGrokClassifierRequest)obj;
        return Objects.equals(this.classification(), other.classification()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.grokPattern(), other.grokPattern()) && Objects.equals(this.customPatterns(), other.customPatterns());
    }

    public String toString() {
        return ToString.builder((String)"CreateGrokClassifierRequest").add("Classification", (Object)this.classification()).add("Name", (Object)this.name()).add("GrokPattern", (Object)this.grokPattern()).add("CustomPatterns", (Object)this.customPatterns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Classification": {
                return Optional.of(clazz.cast(this.classification()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "GrokPattern": {
                return Optional.of(clazz.cast(this.grokPattern()));
            }
            case "CustomPatterns": {
                return Optional.of(clazz.cast(this.customPatterns()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateGrokClassifierRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String classification;
        private String name;
        private String grokPattern;
        private String customPatterns;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrokClassifierRequest model) {
            this.classification(model.classification);
            this.name(model.name);
            this.grokPattern(model.grokPattern);
            this.customPatterns(model.customPatterns);
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getGrokPattern() {
            return this.grokPattern;
        }

        @Override
        public final Builder grokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        public final void setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
        }

        public final String getCustomPatterns() {
            return this.customPatterns;
        }

        @Override
        public final Builder customPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
            return this;
        }

        public final void setCustomPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
        }

        public CreateGrokClassifierRequest build() {
            return new CreateGrokClassifierRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateGrokClassifierRequest> {
        public Builder classification(String var1);

        public Builder name(String var1);

        public Builder grokPattern(String var1);

        public Builder customPatterns(String var1);
    }
}

