/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.ClassifierNameListCopier;
import software.amazon.awssdk.services.glue.model.CrawlerState;
import software.amazon.awssdk.services.glue.model.CrawlerTargets;
import software.amazon.awssdk.services.glue.model.LastCrawlInfo;
import software.amazon.awssdk.services.glue.model.Schedule;
import software.amazon.awssdk.services.glue.model.SchemaChangePolicy;
import software.amazon.awssdk.services.glue.transform.CrawlerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Crawler
implements StructuredPojo,
ToCopyableBuilder<Builder, Crawler> {
    private final String name;
    private final String role;
    private final CrawlerTargets targets;
    private final String databaseName;
    private final String description;
    private final List<String> classifiers;
    private final SchemaChangePolicy schemaChangePolicy;
    private final String state;
    private final String tablePrefix;
    private final Schedule schedule;
    private final Long crawlElapsedTime;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final LastCrawlInfo lastCrawl;
    private final Long version;
    private final String configuration;

    private Crawler(BuilderImpl builder) {
        this.name = builder.name;
        this.role = builder.role;
        this.targets = builder.targets;
        this.databaseName = builder.databaseName;
        this.description = builder.description;
        this.classifiers = builder.classifiers;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.state = builder.state;
        this.tablePrefix = builder.tablePrefix;
        this.schedule = builder.schedule;
        this.crawlElapsedTime = builder.crawlElapsedTime;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.lastCrawl = builder.lastCrawl;
        this.version = builder.version;
        this.configuration = builder.configuration;
    }

    public String name() {
        return this.name;
    }

    public String role() {
        return this.role;
    }

    public CrawlerTargets targets() {
        return this.targets;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String description() {
        return this.description;
    }

    public List<String> classifiers() {
        return this.classifiers;
    }

    public SchemaChangePolicy schemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public CrawlerState state() {
        return CrawlerState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String tablePrefix() {
        return this.tablePrefix;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public Long crawlElapsedTime() {
        return this.crawlElapsedTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public LastCrawlInfo lastCrawl() {
        return this.lastCrawl;
    }

    public Long version() {
        return this.version;
    }

    public String configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlElapsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCrawl());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Crawler)) {
            return false;
        }
        Crawler other = (Crawler)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.classifiers(), other.classifiers()) && Objects.equals(this.schemaChangePolicy(), other.schemaChangePolicy()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.tablePrefix(), other.tablePrefix()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.crawlElapsedTime(), other.crawlElapsedTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.lastCrawl(), other.lastCrawl()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        return ToString.builder((String)"Crawler").add("Name", (Object)this.name()).add("Role", (Object)this.role()).add("Targets", (Object)this.targets()).add("DatabaseName", (Object)this.databaseName()).add("Description", (Object)this.description()).add("Classifiers", this.classifiers()).add("SchemaChangePolicy", (Object)this.schemaChangePolicy()).add("State", (Object)this.stateAsString()).add("TablePrefix", (Object)this.tablePrefix()).add("Schedule", (Object)this.schedule()).add("CrawlElapsedTime", (Object)this.crawlElapsedTime()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("LastCrawl", (Object)this.lastCrawl()).add("Version", (Object)this.version()).add("Configuration", (Object)this.configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Role": {
                return Optional.of(clazz.cast(this.role()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Classifiers": {
                return Optional.of(clazz.cast(this.classifiers()));
            }
            case "SchemaChangePolicy": {
                return Optional.of(clazz.cast(this.schemaChangePolicy()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "TablePrefix": {
                return Optional.of(clazz.cast(this.tablePrefix()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "CrawlElapsedTime": {
                return Optional.of(clazz.cast(this.crawlElapsedTime()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "LastUpdated": {
                return Optional.of(clazz.cast(this.lastUpdated()));
            }
            case "LastCrawl": {
                return Optional.of(clazz.cast(this.lastCrawl()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "Configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CrawlerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String role;
        private CrawlerTargets targets;
        private String databaseName;
        private String description;
        private List<String> classifiers;
        private SchemaChangePolicy schemaChangePolicy;
        private String state;
        private String tablePrefix;
        private Schedule schedule;
        private Long crawlElapsedTime;
        private Instant creationTime;
        private Instant lastUpdated;
        private LastCrawlInfo lastCrawl;
        private Long version;
        private String configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(Crawler model) {
            this.name(model.name);
            this.role(model.role);
            this.targets(model.targets);
            this.databaseName(model.databaseName);
            this.description(model.description);
            this.classifiers(model.classifiers);
            this.schemaChangePolicy(model.schemaChangePolicy);
            this.state(model.state);
            this.tablePrefix(model.tablePrefix);
            this.schedule(model.schedule);
            this.crawlElapsedTime(model.crawlElapsedTime);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.lastCrawl(model.lastCrawl);
            this.version(model.version);
            this.configuration(model.configuration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final CrawlerTargets.Builder getTargets() {
            return this.targets != null ? this.targets.toBuilder() : null;
        }

        @Override
        public final Builder targets(CrawlerTargets targets) {
            this.targets = targets;
            return this;
        }

        public final void setTargets(CrawlerTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getClassifiers() {
            return this.classifiers;
        }

        @Override
        public final Builder classifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(String ... classifiers) {
            this.classifiers(Arrays.asList(classifiers));
            return this;
        }

        public final void setClassifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
        }

        public final SchemaChangePolicy.Builder getSchemaChangePolicy() {
            return this.schemaChangePolicy != null ? this.schemaChangePolicy.toBuilder() : null;
        }

        @Override
        public final Builder schemaChangePolicy(SchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final void setSchemaChangePolicy(SchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CrawlerState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getTablePrefix() {
            return this.tablePrefix;
        }

        @Override
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final Long getCrawlElapsedTime() {
            return this.crawlElapsedTime;
        }

        @Override
        public final Builder crawlElapsedTime(Long crawlElapsedTime) {
            this.crawlElapsedTime = crawlElapsedTime;
            return this;
        }

        public final void setCrawlElapsedTime(Long crawlElapsedTime) {
            this.crawlElapsedTime = crawlElapsedTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final LastCrawlInfo.Builder getLastCrawl() {
            return this.lastCrawl != null ? this.lastCrawl.toBuilder() : null;
        }

        @Override
        public final Builder lastCrawl(LastCrawlInfo lastCrawl) {
            this.lastCrawl = lastCrawl;
            return this;
        }

        public final void setLastCrawl(LastCrawlInfo.BuilderImpl lastCrawl) {
            this.lastCrawl = lastCrawl != null ? lastCrawl.build() : null;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public Crawler build() {
            return new Crawler(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Crawler> {
        public Builder name(String var1);

        public Builder role(String var1);

        public Builder targets(CrawlerTargets var1);

        default public Builder targets(Consumer<CrawlerTargets.Builder> targets) {
            return this.targets((CrawlerTargets)((CrawlerTargets.Builder)CrawlerTargets.builder().apply(targets)).build());
        }

        public Builder databaseName(String var1);

        public Builder description(String var1);

        public Builder classifiers(Collection<String> var1);

        public Builder classifiers(String ... var1);

        public Builder schemaChangePolicy(SchemaChangePolicy var1);

        default public Builder schemaChangePolicy(Consumer<SchemaChangePolicy.Builder> schemaChangePolicy) {
            return this.schemaChangePolicy((SchemaChangePolicy)((SchemaChangePolicy.Builder)SchemaChangePolicy.builder().apply(schemaChangePolicy)).build());
        }

        public Builder state(String var1);

        public Builder state(CrawlerState var1);

        public Builder tablePrefix(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().apply(schedule)).build());
        }

        public Builder crawlElapsedTime(Long var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder lastCrawl(LastCrawlInfo var1);

        default public Builder lastCrawl(Consumer<LastCrawlInfo.Builder> lastCrawl) {
            return this.lastCrawl((LastCrawlInfo)((LastCrawlInfo.Builder)LastCrawlInfo.builder().apply(lastCrawl)).build());
        }

        public Builder version(Long var1);

        public Builder configuration(String var1);
    }
}

