/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunError;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunErrorListCopier;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunSuccessfulSubmission;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunSuccessfulSubmissionListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchStopJobRunResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchStopJobRunResponse> {
    private final List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions;
    private final List<BatchStopJobRunError> errors;

    private BatchStopJobRunResponse(BuilderImpl builder) {
        super(builder);
        this.successfulSubmissions = builder.successfulSubmissions;
        this.errors = builder.errors;
    }

    public List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions() {
        return this.successfulSubmissions;
    }

    public List<BatchStopJobRunError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successfulSubmissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunResponse)) {
            return false;
        }
        BatchStopJobRunResponse other = (BatchStopJobRunResponse)((Object)obj);
        return Objects.equals(this.successfulSubmissions(), other.successfulSubmissions()) && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchStopJobRunResponse").add("SuccessfulSubmissions", this.successfulSubmissions()).add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulSubmissions": {
                return Optional.of(clazz.cast(this.successfulSubmissions()));
            }
            case "Errors": {
                return Optional.of(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions;
        private List<BatchStopJobRunError> errors;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunResponse model) {
            super(model);
            this.successfulSubmissions(model.successfulSubmissions);
            this.errors(model.errors);
        }

        public final Collection<BatchStopJobRunSuccessfulSubmission.Builder> getSuccessfulSubmissions() {
            return this.successfulSubmissions != null ? (Collection)this.successfulSubmissions.stream().map(BatchStopJobRunSuccessfulSubmission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission> successfulSubmissions) {
            this.successfulSubmissions = BatchStopJobRunSuccessfulSubmissionListCopier.copy(successfulSubmissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSubmissions(BatchStopJobRunSuccessfulSubmission ... successfulSubmissions) {
            this.successfulSubmissions(Arrays.asList(successfulSubmissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSubmissions(Consumer<BatchStopJobRunSuccessfulSubmission.Builder> ... successfulSubmissions) {
            this.successfulSubmissions(Stream.of(successfulSubmissions).map(c -> (BatchStopJobRunSuccessfulSubmission)((BatchStopJobRunSuccessfulSubmission.Builder)BatchStopJobRunSuccessfulSubmission.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission.BuilderImpl> successfulSubmissions) {
            this.successfulSubmissions = BatchStopJobRunSuccessfulSubmissionListCopier.copyFromBuilder(successfulSubmissions);
        }

        public final Collection<BatchStopJobRunError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(BatchStopJobRunError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchStopJobRunError> errors) {
            this.errors = BatchStopJobRunErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchStopJobRunError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchStopJobRunError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchStopJobRunError)((BatchStopJobRunError.Builder)BatchStopJobRunError.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchStopJobRunError.BuilderImpl> errors) {
            this.errors = BatchStopJobRunErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchStopJobRunResponse build() {
            return new BatchStopJobRunResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, BatchStopJobRunResponse> {
        public Builder successfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission> var1);

        public Builder successfulSubmissions(BatchStopJobRunSuccessfulSubmission ... var1);

        public Builder successfulSubmissions(Consumer<BatchStopJobRunSuccessfulSubmission.Builder> ... var1);

        public Builder errors(Collection<BatchStopJobRunError> var1);

        public Builder errors(BatchStopJobRunError ... var1);

        public Builder errors(Consumer<BatchStopJobRunError.Builder> ... var1);
    }
}

