/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointConfigurationsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddEndpointsRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, AddEndpointsRequest> {
    private static final SdkField<List<EndpointConfiguration>> ENDPOINT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointConfigurations").getter(AddEndpointsRequest.getter(AddEndpointsRequest::endpointConfigurations)).setter(AddEndpointsRequest.setter(Builder::endpointConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupArn").getter(AddEndpointsRequest.getter(AddEndpointsRequest::endpointGroupArn)).setter(AddEndpointsRequest.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIGURATIONS_FIELD, ENDPOINT_GROUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddEndpointsRequest.memberNameToFieldInitializer();
    private final List<EndpointConfiguration> endpointConfigurations;
    private final String endpointGroupArn;

    private AddEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointConfigurations = builder.endpointConfigurations;
        this.endpointGroupArn = builder.endpointGroupArn;
    }

    public final boolean hasEndpointConfigurations() {
        return this.endpointConfigurations != null && !(this.endpointConfigurations instanceof SdkAutoConstructList);
    }

    public final List<EndpointConfiguration> endpointConfigurations() {
        return this.endpointConfigurations;
    }

    public final String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointConfigurations() ? this.endpointConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddEndpointsRequest)) {
            return false;
        }
        AddEndpointsRequest other = (AddEndpointsRequest)((Object)obj);
        return this.hasEndpointConfigurations() == other.hasEndpointConfigurations() && Objects.equals(this.endpointConfigurations(), other.endpointConfigurations()) && Objects.equals(this.endpointGroupArn(), other.endpointGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"AddEndpointsRequest").add("EndpointConfigurations", this.hasEndpointConfigurations() ? this.endpointConfigurations() : null).add("EndpointGroupArn", (Object)this.endpointGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigurations": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigurations()));
            }
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointConfigurations", ENDPOINT_CONFIGURATIONS_FIELD);
        map.put("EndpointGroupArn", ENDPOINT_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddEndpointsRequest, T> g) {
        return obj -> g.apply((AddEndpointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private List<EndpointConfiguration> endpointConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String endpointGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddEndpointsRequest model) {
            super(model);
            this.endpointConfigurations(model.endpointConfigurations);
            this.endpointGroupArn(model.endpointGroupArn);
        }

        public final List<EndpointConfiguration.Builder> getEndpointConfigurations() {
            List<EndpointConfiguration.Builder> result = EndpointConfigurationsCopier.copyToBuilder(this.endpointConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointConfigurations(Collection<EndpointConfiguration.BuilderImpl> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copyFromBuilder(endpointConfigurations);
        }

        @Override
        public final Builder endpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copy(endpointConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(EndpointConfiguration ... endpointConfigurations) {
            this.endpointConfigurations(Arrays.asList(endpointConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder> ... endpointConfigurations) {
            this.endpointConfigurations(Stream.of(endpointConfigurations).map(c -> (EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddEndpointsRequest build() {
            return new AddEndpointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddEndpointsRequest> {
        public Builder endpointConfigurations(Collection<EndpointConfiguration> var1);

        public Builder endpointConfigurations(EndpointConfiguration ... var1);

        public Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder> ... var1);

        public Builder endpointGroupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

