/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.Attachment;
import software.amazon.awssdk.services.globalaccelerator.model.AttachmentsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCrossAccountAttachmentsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListCrossAccountAttachmentsResponse> {
    private static final SdkField<List<Attachment>> CROSS_ACCOUNT_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrossAccountAttachments").getter(ListCrossAccountAttachmentsResponse.getter(ListCrossAccountAttachmentsResponse::crossAccountAttachments)).setter(ListCrossAccountAttachmentsResponse.setter(Builder::crossAccountAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCrossAccountAttachmentsResponse.getter(ListCrossAccountAttachmentsResponse::nextToken)).setter(ListCrossAccountAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CrossAccountAttachments", CROSS_ACCOUNT_ATTACHMENTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<Attachment> crossAccountAttachments;
    private final String nextToken;

    private ListCrossAccountAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.crossAccountAttachments = builder.crossAccountAttachments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCrossAccountAttachments() {
        return this.crossAccountAttachments != null && !(this.crossAccountAttachments instanceof SdkAutoConstructList);
    }

    public final List<Attachment> crossAccountAttachments() {
        return this.crossAccountAttachments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossAccountAttachments() ? this.crossAccountAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrossAccountAttachmentsResponse)) {
            return false;
        }
        ListCrossAccountAttachmentsResponse other = (ListCrossAccountAttachmentsResponse)((Object)obj);
        return this.hasCrossAccountAttachments() == other.hasCrossAccountAttachments() && Objects.equals(this.crossAccountAttachments(), other.crossAccountAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCrossAccountAttachmentsResponse").add("CrossAccountAttachments", this.hasCrossAccountAttachments() ? this.crossAccountAttachments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrossAccountAttachments": {
                return Optional.ofNullable(clazz.cast(this.crossAccountAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCrossAccountAttachmentsResponse, T> g) {
        return obj -> g.apply((ListCrossAccountAttachmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<Attachment> crossAccountAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrossAccountAttachmentsResponse model) {
            super(model);
            this.crossAccountAttachments(model.crossAccountAttachments);
            this.nextToken(model.nextToken);
        }

        public final List<Attachment.Builder> getCrossAccountAttachments() {
            List<Attachment.Builder> result = AttachmentsCopier.copyToBuilder(this.crossAccountAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossAccountAttachments(Collection<Attachment.BuilderImpl> crossAccountAttachments) {
            this.crossAccountAttachments = AttachmentsCopier.copyFromBuilder(crossAccountAttachments);
        }

        @Override
        public final Builder crossAccountAttachments(Collection<Attachment> crossAccountAttachments) {
            this.crossAccountAttachments = AttachmentsCopier.copy(crossAccountAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountAttachments(Attachment ... crossAccountAttachments) {
            this.crossAccountAttachments(Arrays.asList(crossAccountAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountAttachments(Consumer<Attachment.Builder> ... crossAccountAttachments) {
            this.crossAccountAttachments(Stream.of(crossAccountAttachments).map(c -> (Attachment)((Attachment.Builder)Attachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCrossAccountAttachmentsResponse build() {
            return new ListCrossAccountAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCrossAccountAttachmentsResponse> {
        public Builder crossAccountAttachments(Collection<Attachment> var1);

        public Builder crossAccountAttachments(Attachment ... var1);

        public Builder crossAccountAttachments(Consumer<Attachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

