/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorAttributes;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomRoutingAcceleratorAttributesResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, DescribeCustomRoutingAcceleratorAttributesResponse> {
    private static final SdkField<CustomRoutingAcceleratorAttributes> ACCELERATOR_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AcceleratorAttributes").getter(DescribeCustomRoutingAcceleratorAttributesResponse.getter(DescribeCustomRoutingAcceleratorAttributesResponse::acceleratorAttributes)).setter(DescribeCustomRoutingAcceleratorAttributesResponse.setter(Builder::acceleratorAttributes)).constructor(CustomRoutingAcceleratorAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AcceleratorAttributes", ACCELERATOR_ATTRIBUTES_FIELD);
        }
    });
    private final CustomRoutingAcceleratorAttributes acceleratorAttributes;

    private DescribeCustomRoutingAcceleratorAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorAttributes = builder.acceleratorAttributes;
    }

    public final CustomRoutingAcceleratorAttributes acceleratorAttributes() {
        return this.acceleratorAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomRoutingAcceleratorAttributesResponse)) {
            return false;
        }
        DescribeCustomRoutingAcceleratorAttributesResponse other = (DescribeCustomRoutingAcceleratorAttributesResponse)((Object)obj);
        return Objects.equals(this.acceleratorAttributes(), other.acceleratorAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomRoutingAcceleratorAttributesResponse").add("AcceleratorAttributes", (Object)this.acceleratorAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorAttributes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomRoutingAcceleratorAttributesResponse, T> g) {
        return obj -> g.apply((DescribeCustomRoutingAcceleratorAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private CustomRoutingAcceleratorAttributes acceleratorAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomRoutingAcceleratorAttributesResponse model) {
            super(model);
            this.acceleratorAttributes(model.acceleratorAttributes);
        }

        public final CustomRoutingAcceleratorAttributes.Builder getAcceleratorAttributes() {
            return this.acceleratorAttributes != null ? this.acceleratorAttributes.toBuilder() : null;
        }

        public final void setAcceleratorAttributes(CustomRoutingAcceleratorAttributes.BuilderImpl acceleratorAttributes) {
            this.acceleratorAttributes = acceleratorAttributes != null ? acceleratorAttributes.build() : null;
        }

        @Override
        public final Builder acceleratorAttributes(CustomRoutingAcceleratorAttributes acceleratorAttributes) {
            this.acceleratorAttributes = acceleratorAttributes;
            return this;
        }

        @Override
        public DescribeCustomRoutingAcceleratorAttributesResponse build() {
            return new DescribeCustomRoutingAcceleratorAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomRoutingAcceleratorAttributesResponse> {
        public Builder acceleratorAttributes(CustomRoutingAcceleratorAttributes var1);

        default public Builder acceleratorAttributes(Consumer<CustomRoutingAcceleratorAttributes.Builder> acceleratorAttributes) {
            return this.acceleratorAttributes((CustomRoutingAcceleratorAttributes)((CustomRoutingAcceleratorAttributes.Builder)CustomRoutingAcceleratorAttributes.builder().applyMutation(acceleratorAttributes)).build());
        }
    }
}

