/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.IpAddressType;
import software.amazon.awssdk.services.globalaccelerator.model.IpAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAcceleratorRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, UpdateAcceleratorRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorArn").getter(UpdateAcceleratorRequest.getter(UpdateAcceleratorRequest::acceleratorArn)).setter(UpdateAcceleratorRequest.setter(Builder::acceleratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAcceleratorRequest.getter(UpdateAcceleratorRequest::name)).setter(UpdateAcceleratorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(UpdateAcceleratorRequest.getter(UpdateAcceleratorRequest::ipAddressTypeAsString)).setter(UpdateAcceleratorRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpAddresses").getter(UpdateAcceleratorRequest.getter(UpdateAcceleratorRequest::ipAddresses)).setter(UpdateAcceleratorRequest.setter(Builder::ipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(UpdateAcceleratorRequest.getter(UpdateAcceleratorRequest::enabled)).setter(UpdateAcceleratorRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD, NAME_FIELD, IP_ADDRESS_TYPE_FIELD, IP_ADDRESSES_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAcceleratorRequest.memberNameToFieldInitializer();
    private final String acceleratorArn;
    private final String name;
    private final String ipAddressType;
    private final List<String> ipAddresses;
    private final Boolean enabled;

    private UpdateAcceleratorRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.name = builder.name;
        this.ipAddressType = builder.ipAddressType;
        this.ipAddresses = builder.ipAddresses;
        this.enabled = builder.enabled;
    }

    public final String acceleratorArn() {
        return this.acceleratorArn;
    }

    public final String name() {
        return this.name;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final boolean hasIpAddresses() {
        return this.ipAddresses != null && !(this.ipAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpAddresses() ? this.ipAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAcceleratorRequest)) {
            return false;
        }
        UpdateAcceleratorRequest other = (UpdateAcceleratorRequest)((Object)obj);
        return Objects.equals(this.acceleratorArn(), other.acceleratorArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && this.hasIpAddresses() == other.hasIpAddresses() && Objects.equals(this.ipAddresses(), other.ipAddresses()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAcceleratorRequest").add("AcceleratorArn", (Object)this.acceleratorArn()).add("Name", (Object)this.name()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("IpAddresses", this.hasIpAddresses() ? this.ipAddresses() : null).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorArn": {
                return Optional.ofNullable(clazz.cast(this.acceleratorArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "IpAddresses": {
                return Optional.ofNullable(clazz.cast(this.ipAddresses()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AcceleratorArn", ACCELERATOR_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("IpAddresses", IP_ADDRESSES_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAcceleratorRequest, T> g) {
        return obj -> g.apply((UpdateAcceleratorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String acceleratorArn;
        private String name;
        private String ipAddressType;
        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAcceleratorRequest model) {
            super(model);
            this.acceleratorArn(model.acceleratorArn);
            this.name(model.name);
            this.ipAddressType(model.ipAddressType);
            this.ipAddresses(model.ipAddresses);
            this.enabled(model.enabled);
        }

        public final String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Collection<String> getIpAddresses() {
            if (this.ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipAddresses;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String ... ipAddresses) {
            this.ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAcceleratorRequest build() {
            return new UpdateAcceleratorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAcceleratorRequest> {
        public Builder acceleratorArn(String var1);

        public Builder name(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder ipAddresses(Collection<String> var1);

        public Builder ipAddresses(String ... var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

