/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocol;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingProtocolsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.SocketAddress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortMapping> {
    private static final SdkField<Integer> ACCELERATOR_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AcceleratorPort").getter(PortMapping.getter(PortMapping::acceleratorPort)).setter(PortMapping.setter(Builder::acceleratorPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorPort").build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupArn").getter(PortMapping.getter(PortMapping::endpointGroupArn)).setter(PortMapping.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(PortMapping.getter(PortMapping::endpointId)).setter(PortMapping.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<SocketAddress> DESTINATION_SOCKET_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSocketAddress").getter(PortMapping.getter(PortMapping::destinationSocketAddress)).setter(PortMapping.setter(Builder::destinationSocketAddress)).constructor(SocketAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSocketAddress").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(PortMapping.getter(PortMapping::protocolsAsStrings)).setter(PortMapping.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESTINATION_TRAFFIC_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationTrafficState").getter(PortMapping.getter(PortMapping::destinationTrafficStateAsString)).setter(PortMapping.setter(Builder::destinationTrafficState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTrafficState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_PORT_FIELD, ENDPOINT_GROUP_ARN_FIELD, ENDPOINT_ID_FIELD, DESTINATION_SOCKET_ADDRESS_FIELD, PROTOCOLS_FIELD, DESTINATION_TRAFFIC_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer acceleratorPort;
    private final String endpointGroupArn;
    private final String endpointId;
    private final SocketAddress destinationSocketAddress;
    private final List<String> protocols;
    private final String destinationTrafficState;

    private PortMapping(BuilderImpl builder) {
        this.acceleratorPort = builder.acceleratorPort;
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointId = builder.endpointId;
        this.destinationSocketAddress = builder.destinationSocketAddress;
        this.protocols = builder.protocols;
        this.destinationTrafficState = builder.destinationTrafficState;
    }

    public final Integer acceleratorPort() {
        return this.acceleratorPort;
    }

    public final String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final SocketAddress destinationSocketAddress() {
        return this.destinationSocketAddress;
    }

    public final List<CustomRoutingProtocol> protocols() {
        return CustomRoutingProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final CustomRoutingDestinationTrafficState destinationTrafficState() {
        return CustomRoutingDestinationTrafficState.fromValue(this.destinationTrafficState);
    }

    public final String destinationTrafficStateAsString() {
        return this.destinationTrafficState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSocketAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTrafficStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping other = (PortMapping)obj;
        return Objects.equals(this.acceleratorPort(), other.acceleratorPort()) && Objects.equals(this.endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.destinationSocketAddress(), other.destinationSocketAddress()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.destinationTrafficStateAsString(), other.destinationTrafficStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PortMapping").add("AcceleratorPort", (Object)this.acceleratorPort()).add("EndpointGroupArn", (Object)this.endpointGroupArn()).add("EndpointId", (Object)this.endpointId()).add("DestinationSocketAddress", (Object)this.destinationSocketAddress()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("DestinationTrafficState", (Object)this.destinationTrafficStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorPort": {
                return Optional.ofNullable(clazz.cast(this.acceleratorPort()));
            }
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "DestinationSocketAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationSocketAddress()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "DestinationTrafficState": {
                return Optional.ofNullable(clazz.cast(this.destinationTrafficStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortMapping, T> g) {
        return obj -> g.apply((PortMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer acceleratorPort;
        private String endpointGroupArn;
        private String endpointId;
        private SocketAddress destinationSocketAddress;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private String destinationTrafficState;

        private BuilderImpl() {
        }

        private BuilderImpl(PortMapping model) {
            this.acceleratorPort(model.acceleratorPort);
            this.endpointGroupArn(model.endpointGroupArn);
            this.endpointId(model.endpointId);
            this.destinationSocketAddress(model.destinationSocketAddress);
            this.protocolsWithStrings(model.protocols);
            this.destinationTrafficState(model.destinationTrafficState);
        }

        public final Integer getAcceleratorPort() {
            return this.acceleratorPort;
        }

        public final void setAcceleratorPort(Integer acceleratorPort) {
            this.acceleratorPort = acceleratorPort;
        }

        @Override
        public final Builder acceleratorPort(Integer acceleratorPort) {
            this.acceleratorPort = acceleratorPort;
            return this;
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final SocketAddress.Builder getDestinationSocketAddress() {
            return this.destinationSocketAddress != null ? this.destinationSocketAddress.toBuilder() : null;
        }

        public final void setDestinationSocketAddress(SocketAddress.BuilderImpl destinationSocketAddress) {
            this.destinationSocketAddress = destinationSocketAddress != null ? destinationSocketAddress.build() : null;
        }

        @Override
        public final Builder destinationSocketAddress(SocketAddress destinationSocketAddress) {
            this.destinationSocketAddress = destinationSocketAddress;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = CustomRoutingProtocolsCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = CustomRoutingProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<CustomRoutingProtocol> protocols) {
            this.protocols = CustomRoutingProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(CustomRoutingProtocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getDestinationTrafficState() {
            return this.destinationTrafficState;
        }

        public final void setDestinationTrafficState(String destinationTrafficState) {
            this.destinationTrafficState = destinationTrafficState;
        }

        @Override
        public final Builder destinationTrafficState(String destinationTrafficState) {
            this.destinationTrafficState = destinationTrafficState;
            return this;
        }

        @Override
        public final Builder destinationTrafficState(CustomRoutingDestinationTrafficState destinationTrafficState) {
            this.destinationTrafficState(destinationTrafficState == null ? null : destinationTrafficState.toString());
            return this;
        }

        public PortMapping build() {
            return new PortMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortMapping> {
        public Builder acceleratorPort(Integer var1);

        public Builder endpointGroupArn(String var1);

        public Builder endpointId(String var1);

        public Builder destinationSocketAddress(SocketAddress var1);

        default public Builder destinationSocketAddress(Consumer<SocketAddress.Builder> destinationSocketAddress) {
            return this.destinationSocketAddress((SocketAddress)((SocketAddress.Builder)SocketAddress.builder().applyMutation(destinationSocketAddress)).build());
        }

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<CustomRoutingProtocol> var1);

        public Builder protocols(CustomRoutingProtocol ... var1);

        public Builder destinationTrafficState(String var1);

        public Builder destinationTrafficState(CustomRoutingDestinationTrafficState var1);
    }
}

