/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.internal.UserAgentUtils;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;

public class ListVaultsPublisher
implements SdkPublisher<ListVaultsResponse> {
    private final GlacierAsyncClient client;
    private final ListVaultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVaultsPublisher(GlacierAsyncClient client, ListVaultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVaultsPublisher(GlacierAsyncClient client, ListVaultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVaultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVaultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DescribeVaultOutput> vaultList() {
        Function<ListVaultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vaultList() != null) {
                return response.vaultList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVaultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVaultsResponseFetcher
    implements AsyncPageFetcher<ListVaultsResponse> {
        private ListVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListVaultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListVaultsResponse> nextPage(ListVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListVaultsPublisher.this.client.listVaults(ListVaultsPublisher.this.firstRequest);
            }
            return ListVaultsPublisher.this.client.listVaults((ListVaultsRequest)((Object)ListVaultsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

