/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

public class ListMultipartUploadsIterable
implements SdkIterable<ListMultipartUploadsResponse> {
    private final GlacierClient client;
    private final ListMultipartUploadsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultipartUploadsIterable(GlacierClient client, ListMultipartUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMultipartUploadsResponseFetcher();
    }

    public Iterator<ListMultipartUploadsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UploadListElement> uploadsList() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploadsList() != null) {
                return response.uploadsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMultipartUploadsResponseFetcher
    implements SyncPageFetcher<ListMultipartUploadsResponse> {
        private ListMultipartUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartUploadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListMultipartUploadsResponse nextPage(ListMultipartUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartUploadsIterable.this.client.listMultipartUploads(ListMultipartUploadsIterable.this.firstRequest);
            }
            return ListMultipartUploadsIterable.this.client.listMultipartUploads((ListMultipartUploadsRequest)((Object)ListMultipartUploadsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

