/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput;
import software.amazon.awssdk.services.glacier.model.OutputLocation;
import software.amazon.awssdk.services.glacier.model.SelectParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobParameters> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(JobParameters.getter(JobParameters::format)).setter(JobParameters.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(JobParameters.getter(JobParameters::type)).setter(JobParameters.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(JobParameters.getter(JobParameters::archiveId)).setter(JobParameters.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(JobParameters.getter(JobParameters::description)).setter(JobParameters.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SNSTopic").getter(JobParameters.getter(JobParameters::snsTopic)).setter(JobParameters.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopic").build()}).build();
    private static final SdkField<String> RETRIEVAL_BYTE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrievalByteRange").getter(JobParameters.getter(JobParameters::retrievalByteRange)).setter(JobParameters.setter(Builder::retrievalByteRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalByteRange").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(JobParameters.getter(JobParameters::tier)).setter(JobParameters.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<InventoryRetrievalJobInput> INVENTORY_RETRIEVAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InventoryRetrievalParameters").getter(JobParameters.getter(JobParameters::inventoryRetrievalParameters)).setter(JobParameters.setter(Builder::inventoryRetrievalParameters)).constructor(InventoryRetrievalJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryRetrievalParameters").build()}).build();
    private static final SdkField<SelectParameters> SELECT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectParameters").getter(JobParameters.getter(JobParameters::selectParameters)).setter(JobParameters.setter(Builder::selectParameters)).constructor(SelectParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectParameters").build()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputLocation").getter(JobParameters.getter(JobParameters::outputLocation)).setter(JobParameters.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, TYPE_FIELD, ARCHIVE_ID_FIELD, DESCRIPTION_FIELD, SNS_TOPIC_FIELD, RETRIEVAL_BYTE_RANGE_FIELD, TIER_FIELD, INVENTORY_RETRIEVAL_PARAMETERS_FIELD, SELECT_PARAMETERS_FIELD, OUTPUT_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String type;
    private final String archiveId;
    private final String description;
    private final String snsTopic;
    private final String retrievalByteRange;
    private final String tier;
    private final InventoryRetrievalJobInput inventoryRetrievalParameters;
    private final SelectParameters selectParameters;
    private final OutputLocation outputLocation;

    private JobParameters(BuilderImpl builder) {
        this.format = builder.format;
        this.type = builder.type;
        this.archiveId = builder.archiveId;
        this.description = builder.description;
        this.snsTopic = builder.snsTopic;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
        this.selectParameters = builder.selectParameters;
        this.outputLocation = builder.outputLocation;
    }

    public final String format() {
        return this.format;
    }

    public final String type() {
        return this.type;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final String description() {
        return this.description;
    }

    public final String snsTopic() {
        return this.snsTopic;
    }

    public final String retrievalByteRange() {
        return this.retrievalByteRange;
    }

    public final String tier() {
        return this.tier;
    }

    public final InventoryRetrievalJobInput inventoryRetrievalParameters() {
        return this.inventoryRetrievalParameters;
    }

    public final SelectParameters selectParameters() {
        return this.selectParameters;
    }

    public final OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalByteRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryRetrievalParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        JobParameters other = (JobParameters)obj;
        return Objects.equals(this.format(), other.format()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.retrievalByteRange(), other.retrievalByteRange()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.inventoryRetrievalParameters(), other.inventoryRetrievalParameters()) && Objects.equals(this.selectParameters(), other.selectParameters()) && Objects.equals(this.outputLocation(), other.outputLocation());
    }

    public final String toString() {
        return ToString.builder((String)"JobParameters").add("Format", (Object)this.format()).add("Type", (Object)this.type()).add("ArchiveId", (Object)this.archiveId()).add("Description", (Object)this.description()).add("SNSTopic", (Object)this.snsTopic()).add("RetrievalByteRange", (Object)this.retrievalByteRange()).add("Tier", (Object)this.tier()).add("InventoryRetrievalParameters", (Object)this.inventoryRetrievalParameters()).add("SelectParameters", (Object)this.selectParameters()).add("OutputLocation", (Object)this.outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SNSTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "RetrievalByteRange": {
                return Optional.ofNullable(clazz.cast(this.retrievalByteRange()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
            case "InventoryRetrievalParameters": {
                return Optional.ofNullable(clazz.cast(this.inventoryRetrievalParameters()));
            }
            case "SelectParameters": {
                return Optional.ofNullable(clazz.cast(this.selectParameters()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobParameters, T> g) {
        return obj -> g.apply((JobParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String type;
        private String archiveId;
        private String description;
        private String snsTopic;
        private String retrievalByteRange;
        private String tier;
        private InventoryRetrievalJobInput inventoryRetrievalParameters;
        private SelectParameters selectParameters;
        private OutputLocation outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(JobParameters model) {
            this.format(model.format);
            this.type(model.type);
            this.archiveId(model.archiveId);
            this.description(model.description);
            this.snsTopic(model.snsTopic);
            this.retrievalByteRange(model.retrievalByteRange);
            this.tier(model.tier);
            this.inventoryRetrievalParameters(model.inventoryRetrievalParameters);
            this.selectParameters(model.selectParameters);
            this.outputLocation(model.outputLocation);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        @Transient
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        @Transient
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final String getRetrievalByteRange() {
            return this.retrievalByteRange;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        @Override
        @Transient
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        @Transient
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final InventoryRetrievalJobInput.Builder getInventoryRetrievalParameters() {
            return this.inventoryRetrievalParameters != null ? this.inventoryRetrievalParameters.toBuilder() : null;
        }

        public final void setInventoryRetrievalParameters(InventoryRetrievalJobInput.BuilderImpl inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters != null ? inventoryRetrievalParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobInput inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final SelectParameters.Builder getSelectParameters() {
            return this.selectParameters != null ? this.selectParameters.toBuilder() : null;
        }

        public final void setSelectParameters(SelectParameters.BuilderImpl selectParameters) {
            this.selectParameters = selectParameters != null ? selectParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder selectParameters(SelectParameters selectParameters) {
            this.selectParameters = selectParameters;
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public JobParameters build() {
            return new JobParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobParameters> {
        public Builder format(String var1);

        public Builder type(String var1);

        public Builder archiveId(String var1);

        public Builder description(String var1);

        public Builder snsTopic(String var1);

        public Builder retrievalByteRange(String var1);

        public Builder tier(String var1);

        public Builder inventoryRetrievalParameters(InventoryRetrievalJobInput var1);

        default public Builder inventoryRetrievalParameters(Consumer<InventoryRetrievalJobInput.Builder> inventoryRetrievalParameters) {
            return this.inventoryRetrievalParameters((InventoryRetrievalJobInput)((InventoryRetrievalJobInput.Builder)InventoryRetrievalJobInput.builder().applyMutation(inventoryRetrievalParameters)).build());
        }

        public Builder selectParameters(SelectParameters var1);

        default public Builder selectParameters(Consumer<SelectParameters.Builder> selectParameters) {
            return this.selectParameters((SelectParameters)((SelectParameters.Builder)SelectParameters.builder().applyMutation(selectParameters)).build());
        }

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }
    }
}

