/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVaultLockResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, GetVaultLockResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(GetVaultLockResponse.getter(GetVaultLockResponse::policy)).setter(GetVaultLockResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetVaultLockResponse.getter(GetVaultLockResponse::state)).setter(GetVaultLockResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationDate").getter(GetVaultLockResponse.getter(GetVaultLockResponse::expirationDate)).setter(GetVaultLockResponse.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(GetVaultLockResponse.getter(GetVaultLockResponse::creationDate)).setter(GetVaultLockResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, STATE_FIELD, EXPIRATION_DATE_FIELD, CREATION_DATE_FIELD));
    private final String policy;
    private final String state;
    private final String expirationDate;
    private final String creationDate;

    private GetVaultLockResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.state = builder.state;
        this.expirationDate = builder.expirationDate;
        this.creationDate = builder.creationDate;
    }

    public final String policy() {
        return this.policy;
    }

    public final String state() {
        return this.state;
    }

    public final String expirationDate() {
        return this.expirationDate;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVaultLockResponse)) {
            return false;
        }
        GetVaultLockResponse other = (GetVaultLockResponse)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetVaultLockResponse").add("Policy", (Object)this.policy()).add("State", (Object)this.state()).add("ExpirationDate", (Object)this.expirationDate()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVaultLockResponse, T> g) {
        return obj -> g.apply((GetVaultLockResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String policy;
        private String state;
        private String expirationDate;
        private String creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVaultLockResponse model) {
            super(model);
            this.policy(model.policy);
            this.state(model.state);
            this.expirationDate(model.expirationDate);
            this.creationDate(model.creationDate);
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        @Transient
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public GetVaultLockResponse build() {
            return new GetVaultLockResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVaultLockResponse> {
        public Builder policy(String var1);

        public Builder state(String var1);

        public Builder expirationDate(String var1);

        public Builder creationDate(String var1);
    }
}

