/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.VaultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVaultsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListVaultsResponse> {
    private static final SdkField<List<DescribeVaultOutput>> VAULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VaultList").getter(ListVaultsResponse.getter(ListVaultsResponse::vaultList)).setter(ListVaultsResponse.setter(Builder::vaultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeVaultOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListVaultsResponse.getter(ListVaultsResponse::marker)).setter(ListVaultsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_LIST_FIELD, MARKER_FIELD));
    private final List<DescribeVaultOutput> vaultList;
    private final String marker;

    private ListVaultsResponse(BuilderImpl builder) {
        super(builder);
        this.vaultList = builder.vaultList;
        this.marker = builder.marker;
    }

    public final boolean hasVaultList() {
        return this.vaultList != null && !(this.vaultList instanceof SdkAutoConstructList);
    }

    public final List<DescribeVaultOutput> vaultList() {
        return this.vaultList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVaultList() ? this.vaultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVaultsResponse)) {
            return false;
        }
        ListVaultsResponse other = (ListVaultsResponse)((Object)obj);
        return this.hasVaultList() == other.hasVaultList() && Objects.equals(this.vaultList(), other.vaultList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListVaultsResponse").add("VaultList", this.hasVaultList() ? this.vaultList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultList": {
                return Optional.ofNullable(clazz.cast(this.vaultList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVaultsResponse, T> g) {
        return obj -> g.apply((ListVaultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private List<DescribeVaultOutput> vaultList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVaultsResponse model) {
            super(model);
            this.vaultList(model.vaultList);
            this.marker(model.marker);
        }

        public final List<DescribeVaultOutput.Builder> getVaultList() {
            List<DescribeVaultOutput.Builder> result = VaultListCopier.copyToBuilder(this.vaultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vaultList(Collection<DescribeVaultOutput> vaultList) {
            this.vaultList = VaultListCopier.copy(vaultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultList(DescribeVaultOutput ... vaultList) {
            this.vaultList(Arrays.asList(vaultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultList(Consumer<DescribeVaultOutput.Builder> ... vaultList) {
            this.vaultList(Stream.of(vaultList).map(c -> (DescribeVaultOutput)((DescribeVaultOutput.Builder)DescribeVaultOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVaultList(Collection<DescribeVaultOutput.BuilderImpl> vaultList) {
            this.vaultList = VaultListCopier.copyFromBuilder(vaultList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListVaultsResponse build() {
            return new ListVaultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVaultsResponse> {
        public Builder vaultList(Collection<DescribeVaultOutput> var1);

        public Builder vaultList(DescribeVaultOutput ... var1);

        public Builder vaultList(Consumer<DescribeVaultOutput.Builder> ... var1);

        public Builder marker(String var1);
    }
}

