/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVaultOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeVaultOutput> {
    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultARN").getter(DescribeVaultOutput.getter(DescribeVaultOutput::vaultARN)).setter(DescribeVaultOutput.setter(Builder::vaultARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()}).build();
    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultName").getter(DescribeVaultOutput.getter(DescribeVaultOutput::vaultName)).setter(DescribeVaultOutput.setter(Builder::vaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultName").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(DescribeVaultOutput.getter(DescribeVaultOutput::creationDate)).setter(DescribeVaultOutput.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> LAST_INVENTORY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastInventoryDate").getter(DescribeVaultOutput.getter(DescribeVaultOutput::lastInventoryDate)).setter(DescribeVaultOutput.setter(Builder::lastInventoryDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastInventoryDate").build()}).build();
    private static final SdkField<Long> NUMBER_OF_ARCHIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfArchives").getter(DescribeVaultOutput.getter(DescribeVaultOutput::numberOfArchives)).setter(DescribeVaultOutput.setter(Builder::numberOfArchives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfArchives").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeInBytes").getter(DescribeVaultOutput.getter(DescribeVaultOutput::sizeInBytes)).setter(DescribeVaultOutput.setter(Builder::sizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_ARN_FIELD, VAULT_NAME_FIELD, CREATION_DATE_FIELD, LAST_INVENTORY_DATE_FIELD, NUMBER_OF_ARCHIVES_FIELD, SIZE_IN_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vaultARN;
    private final String vaultName;
    private final String creationDate;
    private final String lastInventoryDate;
    private final Long numberOfArchives;
    private final Long sizeInBytes;

    private DescribeVaultOutput(BuilderImpl builder) {
        this.vaultARN = builder.vaultARN;
        this.vaultName = builder.vaultName;
        this.creationDate = builder.creationDate;
        this.lastInventoryDate = builder.lastInventoryDate;
        this.numberOfArchives = builder.numberOfArchives;
        this.sizeInBytes = builder.sizeInBytes;
    }

    public final String vaultARN() {
        return this.vaultARN;
    }

    public final String vaultName() {
        return this.vaultName;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String lastInventoryDate() {
        return this.lastInventoryDate;
    }

    public final Long numberOfArchives() {
        return this.numberOfArchives;
    }

    public final Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastInventoryDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfArchives());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVaultOutput)) {
            return false;
        }
        DescribeVaultOutput other = (DescribeVaultOutput)obj;
        return Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastInventoryDate(), other.lastInventoryDate()) && Objects.equals(this.numberOfArchives(), other.numberOfArchives()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVaultOutput").add("VaultARN", (Object)this.vaultARN()).add("VaultName", (Object)this.vaultName()).add("CreationDate", (Object)this.creationDate()).add("LastInventoryDate", (Object)this.lastInventoryDate()).add("NumberOfArchives", (Object)this.numberOfArchives()).add("SizeInBytes", (Object)this.sizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultARN": {
                return Optional.ofNullable(clazz.cast(this.vaultARN()));
            }
            case "VaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastInventoryDate": {
                return Optional.ofNullable(clazz.cast(this.lastInventoryDate()));
            }
            case "NumberOfArchives": {
                return Optional.ofNullable(clazz.cast(this.numberOfArchives()));
            }
            case "SizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVaultOutput, T> g) {
        return obj -> g.apply((DescribeVaultOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vaultARN;
        private String vaultName;
        private String creationDate;
        private String lastInventoryDate;
        private Long numberOfArchives;
        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVaultOutput model) {
            this.vaultARN(model.vaultARN);
            this.vaultName(model.vaultName);
            this.creationDate(model.creationDate);
            this.lastInventoryDate(model.lastInventoryDate);
            this.numberOfArchives(model.numberOfArchives);
            this.sizeInBytes(model.sizeInBytes);
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getLastInventoryDate() {
            return this.lastInventoryDate;
        }

        @Override
        public final Builder lastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
            return this;
        }

        public final void setLastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
        }

        public final Long getNumberOfArchives() {
            return this.numberOfArchives;
        }

        @Override
        public final Builder numberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
            return this;
        }

        public final void setNumberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public DescribeVaultOutput build() {
            return new DescribeVaultOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeVaultOutput> {
        public Builder vaultARN(String var1);

        public Builder vaultName(String var1);

        public Builder creationDate(String var1);

        public Builder lastInventoryDate(String var1);

        public Builder numberOfArchives(Long var1);

        public Builder sizeInBytes(Long var1);
    }
}

