/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.PartListCopier;
import software.amazon.awssdk.services.glacier.model.PartListElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPartsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListPartsResponse> {
    private static final SdkField<String> MULTIPART_UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultipartUploadId").getter(ListPartsResponse.getter(ListPartsResponse::multipartUploadId)).setter(ListPartsResponse.setter(Builder::multipartUploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultipartUploadId").build()}).build();
    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultARN").getter(ListPartsResponse.getter(ListPartsResponse::vaultARN)).setter(ListPartsResponse.setter(Builder::vaultARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()}).build();
    private static final SdkField<String> ARCHIVE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveDescription").getter(ListPartsResponse.getter(ListPartsResponse::archiveDescription)).setter(ListPartsResponse.setter(Builder::archiveDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveDescription").build()}).build();
    private static final SdkField<Long> PART_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PartSizeInBytes").getter(ListPartsResponse.getter(ListPartsResponse::partSizeInBytes)).setter(ListPartsResponse.setter(Builder::partSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartSizeInBytes").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(ListPartsResponse.getter(ListPartsResponse::creationDate)).setter(ListPartsResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<List<PartListElement>> PARTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parts").getter(ListPartsResponse.getter(ListPartsResponse::parts)).setter(ListPartsResponse.setter(Builder::parts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartListElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListPartsResponse.getter(ListPartsResponse::marker)).setter(ListPartsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPART_UPLOAD_ID_FIELD, VAULT_ARN_FIELD, ARCHIVE_DESCRIPTION_FIELD, PART_SIZE_IN_BYTES_FIELD, CREATION_DATE_FIELD, PARTS_FIELD, MARKER_FIELD));
    private final String multipartUploadId;
    private final String vaultARN;
    private final String archiveDescription;
    private final Long partSizeInBytes;
    private final String creationDate;
    private final List<PartListElement> parts;
    private final String marker;

    private ListPartsResponse(BuilderImpl builder) {
        super(builder);
        this.multipartUploadId = builder.multipartUploadId;
        this.vaultARN = builder.vaultARN;
        this.archiveDescription = builder.archiveDescription;
        this.partSizeInBytes = builder.partSizeInBytes;
        this.creationDate = builder.creationDate;
        this.parts = builder.parts;
        this.marker = builder.marker;
    }

    public final String multipartUploadId() {
        return this.multipartUploadId;
    }

    public final String vaultARN() {
        return this.vaultARN;
    }

    public final String archiveDescription() {
        return this.archiveDescription;
    }

    public final Long partSizeInBytes() {
        return this.partSizeInBytes;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final boolean hasParts() {
        return this.parts != null && !(this.parts instanceof SdkAutoConstructList);
    }

    public final List<PartListElement> parts() {
        return this.parts;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multipartUploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParts() ? this.parts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsResponse)) {
            return false;
        }
        ListPartsResponse other = (ListPartsResponse)((Object)obj);
        return Objects.equals(this.multipartUploadId(), other.multipartUploadId()) && Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.archiveDescription(), other.archiveDescription()) && Objects.equals(this.partSizeInBytes(), other.partSizeInBytes()) && Objects.equals(this.creationDate(), other.creationDate()) && this.hasParts() == other.hasParts() && Objects.equals(this.parts(), other.parts()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListPartsResponse").add("MultipartUploadId", (Object)this.multipartUploadId()).add("VaultARN", (Object)this.vaultARN()).add("ArchiveDescription", (Object)this.archiveDescription()).add("PartSizeInBytes", (Object)this.partSizeInBytes()).add("CreationDate", (Object)this.creationDate()).add("Parts", this.hasParts() ? this.parts() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultipartUploadId": {
                return Optional.ofNullable(clazz.cast(this.multipartUploadId()));
            }
            case "VaultARN": {
                return Optional.ofNullable(clazz.cast(this.vaultARN()));
            }
            case "ArchiveDescription": {
                return Optional.ofNullable(clazz.cast(this.archiveDescription()));
            }
            case "PartSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.partSizeInBytes()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Parts": {
                return Optional.ofNullable(clazz.cast(this.parts()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPartsResponse, T> g) {
        return obj -> g.apply((ListPartsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String multipartUploadId;
        private String vaultARN;
        private String archiveDescription;
        private Long partSizeInBytes;
        private String creationDate;
        private List<PartListElement> parts = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsResponse model) {
            super(model);
            this.multipartUploadId(model.multipartUploadId);
            this.vaultARN(model.vaultARN);
            this.archiveDescription(model.archiveDescription);
            this.partSizeInBytes(model.partSizeInBytes);
            this.creationDate(model.creationDate);
            this.parts(model.parts);
            this.marker(model.marker);
        }

        public final String getMultipartUploadId() {
            return this.multipartUploadId;
        }

        @Override
        public final Builder multipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
            return this;
        }

        public final void setMultipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final Long getPartSizeInBytes() {
            return this.partSizeInBytes;
        }

        @Override
        public final Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public final void setPartSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final List<PartListElement.Builder> getParts() {
            List<PartListElement.Builder> result = PartListCopier.copyToBuilder(this.parts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parts(Collection<PartListElement> parts) {
            this.parts = PartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(PartListElement ... parts) {
            this.parts(Arrays.asList(parts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Consumer<PartListElement.Builder> ... parts) {
            this.parts(Stream.of(parts).map(c -> (PartListElement)((PartListElement.Builder)PartListElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParts(Collection<PartListElement.BuilderImpl> parts) {
            this.parts = PartListCopier.copyFromBuilder(parts);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListPartsResponse build() {
            return new ListPartsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPartsResponse> {
        public Builder multipartUploadId(String var1);

        public Builder vaultARN(String var1);

        public Builder archiveDescription(String var1);

        public Builder partSizeInBytes(Long var1);

        public Builder creationDate(String var1);

        public Builder parts(Collection<PartListElement> var1);

        public Builder parts(PartListElement ... var1);

        public Builder parts(Consumer<PartListElement.Builder> ... var1);

        public Builder marker(String var1);
    }
}

