/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.GlacierJobDescription;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.JobListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListJobsResponse> {
    private static final SdkField<List<GlacierJobDescription>> JOB_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobList").getter(ListJobsResponse.getter(ListJobsResponse::jobList)).setter(ListJobsResponse.setter(Builder::jobList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlacierJobDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListJobsResponse.getter(ListJobsResponse::marker)).setter(ListJobsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_LIST_FIELD, MARKER_FIELD));
    private final List<GlacierJobDescription> jobList;
    private final String marker;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobList = builder.jobList;
        this.marker = builder.marker;
    }

    public boolean hasJobList() {
        return this.jobList != null && !(this.jobList instanceof SdkAutoConstructList);
    }

    public List<GlacierJobDescription> jobList() {
        return this.jobList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobList() ? this.jobList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse)((Object)obj);
        return this.hasJobList() == other.hasJobList() && Objects.equals(this.jobList(), other.jobList()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListJobsResponse").add("JobList", this.hasJobList() ? this.jobList() : null).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobList": {
                return Optional.ofNullable(clazz.cast(this.jobList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private List<GlacierJobDescription> jobList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            this.jobList(model.jobList);
            this.marker(model.marker);
        }

        public final Collection<GlacierJobDescription.Builder> getJobList() {
            if (this.jobList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobList != null ? (Collection)this.jobList.stream().map(GlacierJobDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobList(Collection<GlacierJobDescription> jobList) {
            this.jobList = JobListCopier.copy(jobList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobList(GlacierJobDescription ... jobList) {
            this.jobList(Arrays.asList(jobList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobList(Consumer<GlacierJobDescription.Builder> ... jobList) {
            this.jobList(Stream.of(jobList).map(c -> (GlacierJobDescription)((GlacierJobDescription.Builder)GlacierJobDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobList(Collection<GlacierJobDescription.BuilderImpl> jobList) {
            this.jobList = JobListCopier.copyFromBuilder(jobList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsResponse> {
        public Builder jobList(Collection<GlacierJobDescription> var1);

        public Builder jobList(GlacierJobDescription ... var1);

        public Builder jobList(Consumer<GlacierJobDescription.Builder> ... var1);

        public Builder marker(String var1);
    }
}

