/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription;
import software.amazon.awssdk.services.glacier.model.ProvisionedCapacityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisionedCapacityResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListProvisionedCapacityResponse> {
    private static final SdkField<List<ProvisionedCapacityDescription>> PROVISIONED_CAPACITY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListProvisionedCapacityResponse.getter(ListProvisionedCapacityResponse::provisionedCapacityList)).setter(ListProvisionedCapacityResponse.setter(Builder::provisionedCapacityList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedCapacityList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisionedCapacityDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_CAPACITY_LIST_FIELD));
    private final List<ProvisionedCapacityDescription> provisionedCapacityList;

    private ListProvisionedCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedCapacityList = builder.provisionedCapacityList;
    }

    public boolean hasProvisionedCapacityList() {
        return this.provisionedCapacityList != null && !(this.provisionedCapacityList instanceof SdkAutoConstructList);
    }

    public List<ProvisionedCapacityDescription> provisionedCapacityList() {
        return this.provisionedCapacityList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedCapacityList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedCapacityResponse)) {
            return false;
        }
        ListProvisionedCapacityResponse other = (ListProvisionedCapacityResponse)((Object)obj);
        return Objects.equals(this.provisionedCapacityList(), other.provisionedCapacityList());
    }

    public String toString() {
        return ToString.builder((String)"ListProvisionedCapacityResponse").add("ProvisionedCapacityList", this.provisionedCapacityList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedCapacityList": {
                return Optional.ofNullable(clazz.cast(this.provisionedCapacityList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedCapacityResponse, T> g) {
        return obj -> g.apply((ListProvisionedCapacityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedCapacityDescription> provisionedCapacityList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedCapacityResponse model) {
            super(model);
            this.provisionedCapacityList(model.provisionedCapacityList);
        }

        public final Collection<ProvisionedCapacityDescription.Builder> getProvisionedCapacityList() {
            return this.provisionedCapacityList != null ? (Collection)this.provisionedCapacityList.stream().map(ProvisionedCapacityDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedCapacityList(Collection<ProvisionedCapacityDescription> provisionedCapacityList) {
            this.provisionedCapacityList = ProvisionedCapacityListCopier.copy(provisionedCapacityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedCapacityList(ProvisionedCapacityDescription ... provisionedCapacityList) {
            this.provisionedCapacityList(Arrays.asList(provisionedCapacityList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedCapacityList(Consumer<ProvisionedCapacityDescription.Builder> ... provisionedCapacityList) {
            this.provisionedCapacityList(Stream.of(provisionedCapacityList).map(c -> (ProvisionedCapacityDescription)((ProvisionedCapacityDescription.Builder)ProvisionedCapacityDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedCapacityList(Collection<ProvisionedCapacityDescription.BuilderImpl> provisionedCapacityList) {
            this.provisionedCapacityList = ProvisionedCapacityListCopier.copyFromBuilder(provisionedCapacityList);
        }

        @Override
        public ListProvisionedCapacityResponse build() {
            return new ListProvisionedCapacityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisionedCapacityResponse> {
        public Builder provisionedCapacityList(Collection<ProvisionedCapacityDescription> var1);

        public Builder provisionedCapacityList(ProvisionedCapacityDescription ... var1);

        public Builder provisionedCapacityList(Consumer<ProvisionedCapacityDescription.Builder> ... var1);
    }
}

