/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobOutputResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, GetJobOutputResponse> {
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobOutputResponse.getter(GetJobOutputResponse::checksum)).setter(GetJobOutputResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-sha256-tree-hash").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetJobOutputResponse.getter(GetJobOutputResponse::status)).setter(GetJobOutputResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("status").build()}).build();
    private static final SdkField<String> CONTENT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobOutputResponse.getter(GetJobOutputResponse::contentRange)).setter(GetJobOutputResponse.setter(Builder::contentRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Range").build()}).build();
    private static final SdkField<String> ACCEPT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobOutputResponse.getter(GetJobOutputResponse::acceptRanges)).setter(GetJobOutputResponse.setter(Builder::acceptRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept-Ranges").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobOutputResponse.getter(GetJobOutputResponse::contentType)).setter(GetJobOutputResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> ARCHIVE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobOutputResponse.getter(GetJobOutputResponse::archiveDescription)).setter(GetJobOutputResponse.setter(Builder::archiveDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-archive-description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKSUM_FIELD, STATUS_FIELD, CONTENT_RANGE_FIELD, ACCEPT_RANGES_FIELD, CONTENT_TYPE_FIELD, ARCHIVE_DESCRIPTION_FIELD));
    private final String checksum;
    private final Integer status;
    private final String contentRange;
    private final String acceptRanges;
    private final String contentType;
    private final String archiveDescription;

    private GetJobOutputResponse(BuilderImpl builder) {
        super(builder);
        this.checksum = builder.checksum;
        this.status = builder.status;
        this.contentRange = builder.contentRange;
        this.acceptRanges = builder.acceptRanges;
        this.contentType = builder.contentType;
        this.archiveDescription = builder.archiveDescription;
    }

    public String checksum() {
        return this.checksum;
    }

    public Integer status() {
        return this.status;
    }

    public String contentRange() {
        return this.contentRange;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public String contentType() {
        return this.contentType;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobOutputResponse)) {
            return false;
        }
        GetJobOutputResponse other = (GetJobOutputResponse)((Object)obj);
        return Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.contentRange(), other.contentRange()) && Objects.equals(this.acceptRanges(), other.acceptRanges()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.archiveDescription(), other.archiveDescription());
    }

    public String toString() {
        return ToString.builder((String)"GetJobOutputResponse").add("Checksum", (Object)this.checksum()).add("Status", (Object)this.status()).add("ContentRange", (Object)this.contentRange()).add("AcceptRanges", (Object)this.acceptRanges()).add("ContentType", (Object)this.contentType()).add("ArchiveDescription", (Object)this.archiveDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "contentRange": {
                return Optional.ofNullable(clazz.cast(this.contentRange()));
            }
            case "acceptRanges": {
                return Optional.ofNullable(clazz.cast(this.acceptRanges()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "archiveDescription": {
                return Optional.ofNullable(clazz.cast(this.archiveDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobOutputResponse, T> g) {
        return obj -> g.apply((GetJobOutputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String checksum;
        private Integer status;
        private String contentRange;
        private String acceptRanges;
        private String contentType;
        private String archiveDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobOutputResponse model) {
            super(model);
            this.checksum(model.checksum);
            this.status(model.status);
            this.contentRange(model.contentRange);
            this.acceptRanges(model.acceptRanges);
            this.contentType(model.contentType);
            this.archiveDescription(model.archiveDescription);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getContentRange() {
            return this.contentRange;
        }

        @Override
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        public final String getAcceptRanges() {
            return this.acceptRanges;
        }

        @Override
        public final Builder acceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
            return this;
        }

        public final void setAcceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        @Override
        public GetJobOutputResponse build() {
            return new GetJobOutputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobOutputResponse> {
        public Builder checksum(String var1);

        public Builder status(Integer var1);

        public Builder contentRange(String var1);

        public Builder acceptRanges(String var1);

        public Builder contentType(String var1);

        public Builder archiveDescription(String var1);
    }
}

