/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultResponse;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.CreateVaultRequest;
import software.amazon.awssdk.services.glacier.model.CreateVaultResponse;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultResponse;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobResponse;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.GlacierException;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobResponse;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.InsufficientCapacityException;
import software.amazon.awssdk.services.glacier.model.InvalidParameterValueException;
import software.amazon.awssdk.services.glacier.model.LimitExceededException;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;
import software.amazon.awssdk.services.glacier.model.MissingParameterValueException;
import software.amazon.awssdk.services.glacier.model.PolicyEnforcedException;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultResponse;
import software.amazon.awssdk.services.glacier.model.RequestTimeoutException;
import software.amazon.awssdk.services.glacier.model.ResourceNotFoundException;
import software.amazon.awssdk.services.glacier.model.ServiceUnavailableException;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse;
import software.amazon.awssdk.services.glacier.paginators.ListJobsIterable;
import software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsIterable;
import software.amazon.awssdk.services.glacier.paginators.ListPartsIterable;
import software.amazon.awssdk.services.glacier.paginators.ListVaultsIterable;
import software.amazon.awssdk.services.glacier.transform.AbortMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.AbortVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.AddTagsToVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.CompleteMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.CompleteVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.CreateVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteArchiveRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DescribeVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetDataRetrievalPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetJobOutputRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateJobRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListMultipartUploadsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListPartsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListProvisionedCapacityRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListTagsForVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListVaultsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.PurchaseProvisionedCapacityRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.RemoveTagsFromVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.SetDataRetrievalPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.SetVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.SetVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.UploadArchiveRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.UploadMultipartPartRequestMarshaller;

@SdkInternalApi
final class DefaultGlacierClient
implements GlacierClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlacierClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "glacier";
    }

    @Override
    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AbortMultipartUploadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AbortMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortMultipartUpload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)abortMultipartUploadRequest).withMarshaller((Marshaller)new AbortMultipartUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AbortVaultLockResponse abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AbortVaultLockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AbortVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortVaultLock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)abortVaultLockRequest).withMarshaller((Marshaller)new AbortVaultLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AddTagsToVaultResponse addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddTagsToVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToVaultRequest).withMarshaller((Marshaller)new AddTagsToVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompleteMultipartUploadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CompleteMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteMultipartUpload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)completeMultipartUploadRequest).withMarshaller((Marshaller)new CompleteMultipartUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CompleteVaultLockResponse completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompleteVaultLockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CompleteVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteVaultLock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)completeVaultLockRequest).withMarshaller((Marshaller)new CompleteVaultLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateVaultResponse createVault(CreateVaultRequest createVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVaultRequest).withMarshaller((Marshaller)new CreateVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteArchiveResponse deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteArchiveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteArchive").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteArchiveRequest).withMarshaller((Marshaller)new DeleteArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteVaultResponse deleteVault(DeleteVaultRequest deleteVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVaultRequest).withMarshaller((Marshaller)new DeleteVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteVaultAccessPolicyResponse deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVaultAccessPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVaultAccessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVaultAccessPolicyRequest).withMarshaller((Marshaller)new DeleteVaultAccessPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteVaultNotificationsResponse deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVaultNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVaultNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVaultNotificationsRequest).withMarshaller((Marshaller)new DeleteVaultNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobRequest).withMarshaller((Marshaller)new DescribeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeVaultResponse describeVault(DescribeVaultRequest describeVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVaultRequest).withMarshaller((Marshaller)new DescribeVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDataRetrievalPolicyResponse getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataRetrievalPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDataRetrievalPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataRetrievalPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataRetrievalPolicyRequest).withMarshaller((Marshaller)new GetDataRetrievalPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public <ReturnT> ReturnT getJobOutput(GetJobOutputRequest getJobOutputRequest, ResponseTransformer<GetJobOutputResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobOutputResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ReturnT)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobOutput").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobOutputRequest).withMarshaller((Marshaller)new GetJobOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
    }

    @Override
    public GetVaultAccessPolicyResponse getVaultAccessPolicy(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVaultAccessPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVaultAccessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVaultAccessPolicyRequest).withMarshaller((Marshaller)new GetVaultAccessPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetVaultLockResponse getVaultLock(GetVaultLockRequest getVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVaultLockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVaultLock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVaultLockRequest).withMarshaller((Marshaller)new GetVaultLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetVaultNotificationsResponse getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVaultNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVaultNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVaultNotificationsRequest).withMarshaller((Marshaller)new GetVaultNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public InitiateJobResponse initiateJob(InitiateJobRequest initiateJobRequest) throws ResourceNotFoundException, PolicyEnforcedException, InvalidParameterValueException, MissingParameterValueException, InsufficientCapacityException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (InitiateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateJobRequest).withMarshaller((Marshaller)new InitiateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public InitiateMultipartUploadResponse initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateMultipartUploadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (InitiateMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateMultipartUpload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateMultipartUploadRequest).withMarshaller((Marshaller)new InitiateMultipartUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public InitiateVaultLockResponse initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateVaultLockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (InitiateVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateVaultLock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateVaultLockRequest).withMarshaller((Marshaller)new InitiateVaultLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return new ListJobsIterable(this, this.applyPaginatorUserAgent(listJobsRequest));
    }

    @Override
    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMultipartUploadsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListMultipartUploadsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultipartUploads").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMultipartUploadsRequest).withMarshaller((Marshaller)new ListMultipartUploadsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListMultipartUploadsIterable listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return new ListMultipartUploadsIterable(this, this.applyPaginatorUserAgent(listMultipartUploadsRequest));
    }

    @Override
    public ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPartsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPartsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPartsRequest).withMarshaller((Marshaller)new ListPartsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPartsIterable listPartsPaginator(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return new ListPartsIterable(this, this.applyPaginatorUserAgent(listPartsRequest));
    }

    @Override
    public ListProvisionedCapacityResponse listProvisionedCapacity(ListProvisionedCapacityRequest listProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProvisionedCapacityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProvisionedCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProvisionedCapacity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProvisionedCapacityRequest).withMarshaller((Marshaller)new ListProvisionedCapacityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForVaultResponse listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForVaultRequest).withMarshaller((Marshaller)new ListTagsForVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListVaultsResponse listVaults(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVaultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListVaultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVaults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVaultsRequest).withMarshaller((Marshaller)new ListVaultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListVaultsIterable listVaultsPaginator(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        return new ListVaultsIterable(this, this.applyPaginatorUserAgent(listVaultsRequest));
    }

    @Override
    public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseProvisionedCapacityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PurchaseProvisionedCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseProvisionedCapacity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)purchaseProvisionedCapacityRequest).withMarshaller((Marshaller)new PurchaseProvisionedCapacityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromVaultResponse removeTagsFromVault(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemoveTagsFromVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromVaultRequest).withMarshaller((Marshaller)new RemoveTagsFromVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SetDataRetrievalPolicyResponse setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetDataRetrievalPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SetDataRetrievalPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetDataRetrievalPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setDataRetrievalPolicyRequest).withMarshaller((Marshaller)new SetDataRetrievalPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SetVaultAccessPolicyResponse setVaultAccessPolicy(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetVaultAccessPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SetVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetVaultAccessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setVaultAccessPolicyRequest).withMarshaller((Marshaller)new SetVaultAccessPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SetVaultNotificationsResponse setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetVaultNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SetVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetVaultNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setVaultNotificationsRequest).withMarshaller((Marshaller)new SetVaultNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadArchiveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UploadArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadArchive").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)uploadArchiveRequest).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new UploadArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory))).requestBody(requestBody).build()));
    }

    @Override
    public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, AwsServiceException, SdkClientException, GlacierException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadMultipartPartResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UploadMultipartPartResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadMultipartPart").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)uploadMultipartPartRequest).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new UploadMultipartPartRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory))).requestBody(requestBody).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GlacierException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").customErrorCodeFieldName("code").registerModeledException(ExceptionMetadata.builder().errorCode("RequestTimeoutException").exceptionBuilderSupplier(RequestTimeoutException::builder).httpStatusCode(Integer.valueOf(408)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingParameterValueException").exceptionBuilderSupplier(MissingParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").exceptionBuilderSupplier(InsufficientCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyEnforcedException").exceptionBuilderSupplier(PolicyEnforcedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends GlacierRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.7").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GlacierRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

