/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for a range inventory retrieval job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryRetrievalJobDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryRetrievalJobDescription.Builder, InventoryRetrievalJobDescription> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InventoryRetrievalJobDescription::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InventoryRetrievalJobDescription::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InventoryRetrievalJobDescription::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<String> LIMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InventoryRetrievalJobDescription::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InventoryRetrievalJobDescription::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            START_DATE_FIELD, END_DATE_FIELD, LIMIT_FIELD, MARKER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String startDate;

    private final String endDate;

    private final String limit;

    private final String marker;

    private InventoryRetrievalJobDescription(BuilderImpl builder) {
        this.format = builder.format;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when initiating a
     * job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.
     * </p>
     * 
     * @return The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when
     *         initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes
     * archives created on or after this date. This value should be a string in the ISO 8601 date format, for example
     * <code>2013-03-20T17:03:43Z</code>.
     * </p>
     * 
     * @return The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that
     *         includes archives created on or after this date. This value should be a string in the ISO 8601 date
     *         format, for example <code>2013-03-20T17:03:43Z</code>.
     */
    public String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The end of the date range in UTC for vault inventory retrieval that includes archives created before this date.
     * This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.
     * </p>
     * 
     * @return The end of the date range in UTC for vault inventory retrieval that includes archives created before this
     *         date. This value should be a string in the ISO 8601 date format, for example
     *         <code>2013-03-20T17:03:43Z</code>.
     */
    public String endDate() {
        return endDate;
    }

    /**
     * <p>
     * The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when
     * initiating the job with the a <b>InitiateJob</b> request.
     * </p>
     * 
     * @return The maximum number of inventory items returned per vault inventory retrieval request. This limit is set
     *         when initiating the job with the a <b>InitiateJob</b> request.
     */
    public String limit() {
        return limit;
    }

    /**
     * <p>
     * An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use
     * the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more
     * inventory items, this value is <code>null</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"
     * > Range Inventory Retrieval</a>.
     * </p>
     * 
     * @return An opaque string that represents where to continue pagination of the vault inventory retrieval results.
     *         You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are
     *         no more inventory items, this value is <code>null</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"
     *         > Range Inventory Retrieval</a>.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryRetrievalJobDescription)) {
            return false;
        }
        InventoryRetrievalJobDescription other = (InventoryRetrievalJobDescription) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(limit(), other.limit())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InventoryRetrievalJobDescription").add("Format", format()).add("StartDate", startDate())
                .add("EndDate", endDate()).add("Limit", limit()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryRetrievalJobDescription, T> g) {
        return obj -> g.apply((InventoryRetrievalJobDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryRetrievalJobDescription> {
        /**
         * <p>
         * The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when
         * initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.
         * </p>
         * 
         * @param format
         *        The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when
         *        initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and
         *        <code>JSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes
         * archives created on or after this date. This value should be a string in the ISO 8601 date format, for
         * example <code>2013-03-20T17:03:43Z</code>.
         * </p>
         * 
         * @param startDate
         *        The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that
         *        includes archives created on or after this date. This value should be a string in the ISO 8601 date
         *        format, for example <code>2013-03-20T17:03:43Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The end of the date range in UTC for vault inventory retrieval that includes archives created before this
         * date. This value should be a string in the ISO 8601 date format, for example
         * <code>2013-03-20T17:03:43Z</code>.
         * </p>
         * 
         * @param endDate
         *        The end of the date range in UTC for vault inventory retrieval that includes archives created before
         *        this date. This value should be a string in the ISO 8601 date format, for example
         *        <code>2013-03-20T17:03:43Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * <p>
         * The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when
         * initiating the job with the a <b>InitiateJob</b> request.
         * </p>
         * 
         * @param limit
         *        The maximum number of inventory items returned per vault inventory retrieval request. This limit is
         *        set when initiating the job with the a <b>InitiateJob</b> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(String limit);

        /**
         * <p>
         * An opaque string that represents where to continue pagination of the vault inventory retrieval results. You
         * use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more
         * inventory items, this value is <code>null</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"
         * > Range Inventory Retrieval</a>.
         * </p>
         * 
         * @param marker
         *        An opaque string that represents where to continue pagination of the vault inventory retrieval
         *        results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items.
         *        If there are no more inventory items, this value is <code>null</code>. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"
         *        > Range Inventory Retrieval</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String startDate;

        private String endDate;

        private String limit;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryRetrievalJobDescription model) {
            format(model.format);
            startDate(model.startDate);
            endDate(model.endDate);
            limit(model.limit);
            marker(model.marker);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final String getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public InventoryRetrievalJobDescription build() {
            return new InventoryRetrievalJobDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
