/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides options for initiating an Amazon S3 Glacier job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitiateJobRequest extends GlacierRequest implements
        ToCopyableBuilder<InitiateJobRequest.Builder, InitiateJobRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InitiateJobRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(),
                    DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())).build();

    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InitiateJobRequest::vaultName)).setter(setter(Builder::vaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("vaultName").build()).build();

    private static final SdkField<JobParameters> JOB_PARAMETERS_FIELD = SdkField
            .<JobParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(InitiateJobRequest::jobParameters))
            .setter(setter(Builder::jobParameters))
            .constructor(JobParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameters").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            VAULT_NAME_FIELD, JOB_PARAMETERS_FIELD));

    private final String accountId;

    private final String vaultName;

    private final JobParameters jobParameters;

    private InitiateJobRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.jobParameters = builder.jobParameters;
    }

    /**
     * <p>
     * The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify
     * an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3 Glacier uses the AWS
     * account ID associated with the credentials used to sign the request. If you use an account ID, do not include any
     * hyphens ('-') in the ID.
     * </p>
     * 
     * @return The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either
     *         specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3
     *         Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an
     *         account ID, do not include any hyphens ('-') in the ID.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the vault.
     * </p>
     * 
     * @return The name of the vault.
     */
    public String vaultName() {
        return vaultName;
    }

    /**
     * <p>
     * Provides options for specifying job information.
     * </p>
     * 
     * @return Provides options for specifying job information.
     */
    public JobParameters jobParameters() {
        return jobParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(jobParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateJobRequest)) {
            return false;
        }
        InitiateJobRequest other = (InitiateJobRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(vaultName(), other.vaultName())
                && Objects.equals(jobParameters(), other.jobParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InitiateJobRequest").add("AccountId", accountId()).add("VaultName", vaultName())
                .add("JobParameters", jobParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "vaultName":
            return Optional.ofNullable(clazz.cast(vaultName()));
        case "jobParameters":
            return Optional.ofNullable(clazz.cast(jobParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitiateJobRequest, T> g) {
        return obj -> g.apply((InitiateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierRequest.Builder, SdkPojo, CopyableBuilder<Builder, InitiateJobRequest> {
        /**
         * <p>
         * The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either
         * specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3 Glacier
         * uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID,
         * do not include any hyphens ('-') in the ID.
         * </p>
         * 
         * @param accountId
         *        The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can
         *        either specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case
         *        Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If
         *        you use an account ID, do not include any hyphens ('-') in the ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the vault.
         * </p>
         * 
         * @param vaultName
         *        The name of the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultName(String vaultName);

        /**
         * <p>
         * Provides options for specifying job information.
         * </p>
         * 
         * @param jobParameters
         *        Provides options for specifying job information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobParameters(JobParameters jobParameters);

        /**
         * <p>
         * Provides options for specifying job information.
         * </p>
         * This is a convenience that creates an instance of the {@link JobParameters.Builder} avoiding the need to
         * create one manually via {@link JobParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #jobParameters(JobParameters)}.
         * 
         * @param jobParameters
         *        a consumer that will call methods on {@link JobParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobParameters(JobParameters)
         */
        default Builder jobParameters(Consumer<JobParameters.Builder> jobParameters) {
            return jobParameters(JobParameters.builder().applyMutation(jobParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlacierRequest.BuilderImpl implements Builder {
        private String accountId;

        private String vaultName;

        private JobParameters jobParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateJobRequest model) {
            super(model);
            accountId(model.accountId);
            vaultName(model.vaultName);
            jobParameters(model.jobParameters);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final JobParameters.Builder getJobParameters() {
            return jobParameters != null ? jobParameters.toBuilder() : null;
        }

        @Override
        public final Builder jobParameters(JobParameters jobParameters) {
            this.jobParameters = jobParameters;
            return this;
        }

        public final void setJobParameters(JobParameters.BuilderImpl jobParameters) {
            this.jobParameters = jobParameters != null ? jobParameters.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitiateJobRequest build() {
            return new InitiateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
