/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the description of an Amazon S3 Glacier job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlacierJobDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<GlacierJobDescription.Builder, GlacierJobDescription> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::jobDescription)).setter(setter(Builder::jobDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::archiveId)).setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()).build();

    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::vaultARN)).setter(setter(Builder::vaultARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Boolean> COMPLETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GlacierJobDescription::completed)).setter(setter(Builder::completed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Long> ARCHIVE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GlacierJobDescription::archiveSizeInBytes)).setter(setter(Builder::archiveSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveSizeInBytes").build())
            .build();

    private static final SdkField<Long> INVENTORY_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GlacierJobDescription::inventorySizeInBytes)).setter(setter(Builder::inventorySizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventorySizeInBytes").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::snsTopic)).setter(setter(Builder::snsTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopic").build()).build();

    private static final SdkField<String> COMPLETION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::completionDate)).setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<String> SHA256_TREE_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::sha256TreeHash)).setter(setter(Builder::sha256TreeHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SHA256TreeHash").build()).build();

    private static final SdkField<String> ARCHIVE_SHA256_TREE_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::archiveSHA256TreeHash)).setter(setter(Builder::archiveSHA256TreeHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveSHA256TreeHash").build())
            .build();

    private static final SdkField<String> RETRIEVAL_BYTE_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::retrievalByteRange)).setter(setter(Builder::retrievalByteRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievalByteRange").build())
            .build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::tier)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<InventoryRetrievalJobDescription> INVENTORY_RETRIEVAL_PARAMETERS_FIELD = SdkField
            .<InventoryRetrievalJobDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(GlacierJobDescription::inventoryRetrievalParameters))
            .setter(setter(Builder::inventoryRetrievalParameters))
            .constructor(InventoryRetrievalJobDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryRetrievalParameters")
                    .build()).build();

    private static final SdkField<String> JOB_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlacierJobDescription::jobOutputPath)).setter(setter(Builder::jobOutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobOutputPath").build()).build();

    private static final SdkField<SelectParameters> SELECT_PARAMETERS_FIELD = SdkField
            .<SelectParameters> builder(MarshallingType.SDK_POJO).getter(getter(GlacierJobDescription::selectParameters))
            .setter(setter(Builder::selectParameters)).constructor(SelectParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectParameters").build()).build();

    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).getter(getter(GlacierJobDescription::outputLocation))
            .setter(setter(Builder::outputLocation)).constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            JOB_DESCRIPTION_FIELD, ACTION_FIELD, ARCHIVE_ID_FIELD, VAULT_ARN_FIELD, CREATION_DATE_FIELD, COMPLETED_FIELD,
            STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, ARCHIVE_SIZE_IN_BYTES_FIELD, INVENTORY_SIZE_IN_BYTES_FIELD, SNS_TOPIC_FIELD,
            COMPLETION_DATE_FIELD, SHA256_TREE_HASH_FIELD, ARCHIVE_SHA256_TREE_HASH_FIELD, RETRIEVAL_BYTE_RANGE_FIELD,
            TIER_FIELD, INVENTORY_RETRIEVAL_PARAMETERS_FIELD, JOB_OUTPUT_PATH_FIELD, SELECT_PARAMETERS_FIELD,
            OUTPUT_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobDescription;

    private final String action;

    private final String archiveId;

    private final String vaultARN;

    private final String creationDate;

    private final Boolean completed;

    private final String statusCode;

    private final String statusMessage;

    private final Long archiveSizeInBytes;

    private final Long inventorySizeInBytes;

    private final String snsTopic;

    private final String completionDate;

    private final String sha256TreeHash;

    private final String archiveSHA256TreeHash;

    private final String retrievalByteRange;

    private final String tier;

    private final InventoryRetrievalJobDescription inventoryRetrievalParameters;

    private final String jobOutputPath;

    private final SelectParameters selectParameters;

    private final OutputLocation outputLocation;

    private GlacierJobDescription(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobDescription = builder.jobDescription;
        this.action = builder.action;
        this.archiveId = builder.archiveId;
        this.vaultARN = builder.vaultARN;
        this.creationDate = builder.creationDate;
        this.completed = builder.completed;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.archiveSizeInBytes = builder.archiveSizeInBytes;
        this.inventorySizeInBytes = builder.inventorySizeInBytes;
        this.snsTopic = builder.snsTopic;
        this.completionDate = builder.completionDate;
        this.sha256TreeHash = builder.sha256TreeHash;
        this.archiveSHA256TreeHash = builder.archiveSHA256TreeHash;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
        this.jobOutputPath = builder.jobOutputPath;
        this.selectParameters = builder.selectParameters;
        this.outputLocation = builder.outputLocation;
    }

    /**
     * <p>
     * An opaque string that identifies an Amazon S3 Glacier job.
     * </p>
     * 
     * @return An opaque string that identifies an Amazon S3 Glacier job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job description provided when initiating the job.
     * </p>
     * 
     * @return The job description provided when initiating the job.
     */
    public String jobDescription() {
        return jobDescription;
    }

    /**
     * <p>
     * The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
     * <code>Select</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ActionCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
     *         <code>Select</code>.
     * @see ActionCode
     */
    public ActionCode action() {
        return ActionCode.fromValue(action);
    }

    /**
     * <p>
     * The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
     * <code>Select</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ActionCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
     *         <code>Select</code>.
     * @see ActionCode
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.
     * </p>
     * 
     * @return The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.
     */
    public String archiveId() {
        return archiveId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.
     */
    public String vaultARN() {
        return vaultARN;
    }

    /**
     * <p>
     * The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for example
     * <code>"2012-03-20T17:03:43.221Z"</code>.
     * </p>
     * 
     * @return The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for
     *         example <code>"2012-03-20T17:03:43.221Z"</code>.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The job status. When a job is completed, you get the job's output using Get Job Output (GET output).
     * </p>
     * 
     * @return The job status. When a job is completed, you get the job's output using Get Job Output (GET output).
     */
    public Boolean completed() {
        return completed;
    }

    /**
     * <p>
     * The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates the
     * status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and
     *         indicates the status of the job.
     * @see StatusCode
     */
    public StatusCode statusCode() {
        return StatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates the
     * status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and
     *         indicates the status of the job.
     * @see StatusCode
     */
    public String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * A friendly message that describes the job status.
     * </p>
     * 
     * @return A friendly message that describes the job status.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * For an archive retrieval job, this value is the size in bytes of the archive being requested for download. For an
     * inventory retrieval or select job, this value is null.
     * </p>
     * 
     * @return For an archive retrieval job, this value is the size in bytes of the archive being requested for
     *         download. For an inventory retrieval or select job, this value is null.
     */
    public Long archiveSizeInBytes() {
        return archiveSizeInBytes;
    }

    /**
     * <p>
     * For an inventory retrieval job, this value is the size in bytes of the inventory requested for download. For an
     * archive retrieval or select job, this value is null.
     * </p>
     * 
     * @return For an inventory retrieval job, this value is the size in bytes of the inventory requested for download.
     *         For an archive retrieval or select job, this value is null.
     */
    public Long inventorySizeInBytes() {
        return inventorySizeInBytes;
    }

    /**
     * <p>
     * An Amazon SNS topic that receives notification.
     * </p>
     * 
     * @return An Amazon SNS topic that receives notification.
     */
    public String snsTopic() {
        return snsTopic;
    }

    /**
     * <p>
     * The UTC time that the job request completed. While the job is in progress, the value is null.
     * </p>
     * 
     * @return The UTC time that the job request completed. While the job is in progress, the value is null.
     */
    public String completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is null.
     * </p>
     * <p>
     * The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an
     * archive specified a tree-hash aligned range, then this field returns a value.
     * </p>
     * <p>
     * If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.
     * </p>
     * <p>
     * This field is null for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Archive retrieval jobs that specify a range that is not tree-hash aligned
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Archival jobs that specify a range that is equal to the whole archive, when the job status is
     * <code>InProgress</code>
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Inventory jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * Select jobs
     * </p>
     * </li>
     * </ul>
     * 
     * @return For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is
     *         null.</p>
     *         <p>
     *         The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for
     *         an archive specified a tree-hash aligned range, then this field returns a value.
     *         </p>
     *         <p>
     *         If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.
     *         </p>
     *         <p>
     *         This field is null for the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Archive retrieval jobs that specify a range that is not tree-hash aligned
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Archival jobs that specify a range that is equal to the whole archive, when the job status is
     *         <code>InProgress</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Inventory jobs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Select jobs
     *         </p>
     *         </li>
     */
    public String sha256TreeHash() {
        return sha256TreeHash;
    }

    /**
     * <p>
     * The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select jobs, this
     * field is null.
     * </p>
     * 
     * @return The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select
     *         jobs, this field is null.
     */
    public String archiveSHA256TreeHash() {
        return archiveSHA256TreeHash;
    }

    /**
     * <p>
     * The retrieved byte range for archive retrieval jobs in the form <i>StartByteValue</i>-<i>EndByteValue</i>. If no
     * range was specified in the archive retrieval, then the whole archive is retrieved. In this case,
     * <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals the size of the archive minus 1. For inventory
     * retrieval or select jobs, this field is null.
     * </p>
     * 
     * @return The retrieved byte range for archive retrieval jobs in the form
     *         <i>StartByteValue</i>-<i>EndByteValue</i>. If no range was specified in the archive retrieval, then the
     *         whole archive is retrieved. In this case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals
     *         the size of the archive minus 1. For inventory retrieval or select jobs, this field is null.
     */
    public String retrievalByteRange() {
        return retrievalByteRange;
    }

    /**
     * <p>
     * The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>,
     * <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
     * </p>
     * 
     * @return The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>,
     *         <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
     */
    public String tier() {
        return tier;
    }

    /**
     * <p>
     * Parameters used for range inventory retrieval.
     * </p>
     * 
     * @return Parameters used for range inventory retrieval.
     */
    public InventoryRetrievalJobDescription inventoryRetrievalParameters() {
        return inventoryRetrievalParameters;
    }

    /**
     * <p>
     * Contains the job output location.
     * </p>
     * 
     * @return Contains the job output location.
     */
    public String jobOutputPath() {
        return jobOutputPath;
    }

    /**
     * <p>
     * Contains the parameters used for a select.
     * </p>
     * 
     * @return Contains the parameters used for a select.
     */
    public SelectParameters selectParameters() {
        return selectParameters;
    }

    /**
     * <p>
     * Contains the location where the data from the select job is stored.
     * </p>
     * 
     * @return Contains the location where the data from the select job is stored.
     */
    public OutputLocation outputLocation() {
        return outputLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(completed());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(archiveSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(inventorySizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(sha256TreeHash());
        hashCode = 31 * hashCode + Objects.hashCode(archiveSHA256TreeHash());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalByteRange());
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        hashCode = 31 * hashCode + Objects.hashCode(inventoryRetrievalParameters());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(selectParameters());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlacierJobDescription)) {
            return false;
        }
        GlacierJobDescription other = (GlacierJobDescription) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobDescription(), other.jobDescription())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(archiveId(), other.archiveId())
                && Objects.equals(vaultARN(), other.vaultARN()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(completed(), other.completed())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(archiveSizeInBytes(), other.archiveSizeInBytes())
                && Objects.equals(inventorySizeInBytes(), other.inventorySizeInBytes())
                && Objects.equals(snsTopic(), other.snsTopic()) && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(sha256TreeHash(), other.sha256TreeHash())
                && Objects.equals(archiveSHA256TreeHash(), other.archiveSHA256TreeHash())
                && Objects.equals(retrievalByteRange(), other.retrievalByteRange()) && Objects.equals(tier(), other.tier())
                && Objects.equals(inventoryRetrievalParameters(), other.inventoryRetrievalParameters())
                && Objects.equals(jobOutputPath(), other.jobOutputPath())
                && Objects.equals(selectParameters(), other.selectParameters())
                && Objects.equals(outputLocation(), other.outputLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GlacierJobDescription").add("JobId", jobId()).add("JobDescription", jobDescription())
                .add("Action", actionAsString()).add("ArchiveId", archiveId()).add("VaultARN", vaultARN())
                .add("CreationDate", creationDate()).add("Completed", completed()).add("StatusCode", statusCodeAsString())
                .add("StatusMessage", statusMessage()).add("ArchiveSizeInBytes", archiveSizeInBytes())
                .add("InventorySizeInBytes", inventorySizeInBytes()).add("SNSTopic", snsTopic())
                .add("CompletionDate", completionDate()).add("SHA256TreeHash", sha256TreeHash())
                .add("ArchiveSHA256TreeHash", archiveSHA256TreeHash()).add("RetrievalByteRange", retrievalByteRange())
                .add("Tier", tier()).add("InventoryRetrievalParameters", inventoryRetrievalParameters())
                .add("JobOutputPath", jobOutputPath()).add("SelectParameters", selectParameters())
                .add("OutputLocation", outputLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobDescription":
            return Optional.ofNullable(clazz.cast(jobDescription()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "ArchiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        case "VaultARN":
            return Optional.ofNullable(clazz.cast(vaultARN()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Completed":
            return Optional.ofNullable(clazz.cast(completed()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ArchiveSizeInBytes":
            return Optional.ofNullable(clazz.cast(archiveSizeInBytes()));
        case "InventorySizeInBytes":
            return Optional.ofNullable(clazz.cast(inventorySizeInBytes()));
        case "SNSTopic":
            return Optional.ofNullable(clazz.cast(snsTopic()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "SHA256TreeHash":
            return Optional.ofNullable(clazz.cast(sha256TreeHash()));
        case "ArchiveSHA256TreeHash":
            return Optional.ofNullable(clazz.cast(archiveSHA256TreeHash()));
        case "RetrievalByteRange":
            return Optional.ofNullable(clazz.cast(retrievalByteRange()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        case "InventoryRetrievalParameters":
            return Optional.ofNullable(clazz.cast(inventoryRetrievalParameters()));
        case "JobOutputPath":
            return Optional.ofNullable(clazz.cast(jobOutputPath()));
        case "SelectParameters":
            return Optional.ofNullable(clazz.cast(selectParameters()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlacierJobDescription, T> g) {
        return obj -> g.apply((GlacierJobDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlacierJobDescription> {
        /**
         * <p>
         * An opaque string that identifies an Amazon S3 Glacier job.
         * </p>
         * 
         * @param jobId
         *        An opaque string that identifies an Amazon S3 Glacier job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job description provided when initiating the job.
         * </p>
         * 
         * @param jobDescription
         *        The job description provided when initiating the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDescription(String jobDescription);

        /**
         * <p>
         * The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
         * <code>Select</code>.
         * </p>
         * 
         * @param action
         *        The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
         *        <code>Select</code>.
         * @see ActionCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCode
         */
        Builder action(String action);

        /**
         * <p>
         * The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
         * <code>Select</code>.
         * </p>
         * 
         * @param action
         *        The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or
         *        <code>Select</code>.
         * @see ActionCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCode
         */
        Builder action(ActionCode action);

        /**
         * <p>
         * The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.
         * </p>
         * 
         * @param archiveId
         *        The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.
         * </p>
         * 
         * @param vaultARN
         *        The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultARN(String vaultARN);

        /**
         * <p>
         * The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for
         * example <code>"2012-03-20T17:03:43.221Z"</code>.
         * </p>
         * 
         * @param creationDate
         *        The UTC date when the job was created. This value is a string representation of ISO 8601 date format,
         *        for example <code>"2012-03-20T17:03:43.221Z"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The job status. When a job is completed, you get the job's output using Get Job Output (GET output).
         * </p>
         * 
         * @param completed
         *        The job status. When a job is completed, you get the job's output using Get Job Output (GET output).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completed(Boolean completed);

        /**
         * <p>
         * The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates
         * the status of the job.
         * </p>
         * 
         * @param statusCode
         *        The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and
         *        indicates the status of the job.
         * @see StatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates
         * the status of the job.
         * </p>
         * 
         * @param statusCode
         *        The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and
         *        indicates the status of the job.
         * @see StatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusCode
         */
        Builder statusCode(StatusCode statusCode);

        /**
         * <p>
         * A friendly message that describes the job status.
         * </p>
         * 
         * @param statusMessage
         *        A friendly message that describes the job status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * For an archive retrieval job, this value is the size in bytes of the archive being requested for download.
         * For an inventory retrieval or select job, this value is null.
         * </p>
         * 
         * @param archiveSizeInBytes
         *        For an archive retrieval job, this value is the size in bytes of the archive being requested for
         *        download. For an inventory retrieval or select job, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveSizeInBytes(Long archiveSizeInBytes);

        /**
         * <p>
         * For an inventory retrieval job, this value is the size in bytes of the inventory requested for download. For
         * an archive retrieval or select job, this value is null.
         * </p>
         * 
         * @param inventorySizeInBytes
         *        For an inventory retrieval job, this value is the size in bytes of the inventory requested for
         *        download. For an archive retrieval or select job, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventorySizeInBytes(Long inventorySizeInBytes);

        /**
         * <p>
         * An Amazon SNS topic that receives notification.
         * </p>
         * 
         * @param snsTopic
         *        An Amazon SNS topic that receives notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopic(String snsTopic);

        /**
         * <p>
         * The UTC time that the job request completed. While the job is in progress, the value is null.
         * </p>
         * 
         * @param completionDate
         *        The UTC time that the job request completed. While the job is in progress, the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(String completionDate);

        /**
         * <p>
         * For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is null.
         * </p>
         * <p>
         * The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an
         * archive specified a tree-hash aligned range, then this field returns a value.
         * </p>
         * <p>
         * If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.
         * </p>
         * <p>
         * This field is null for the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Archive retrieval jobs that specify a range that is not tree-hash aligned
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Archival jobs that specify a range that is equal to the whole archive, when the job status is
         * <code>InProgress</code>
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Inventory jobs
         * </p>
         * </li>
         * <li>
         * <p>
         * Select jobs
         * </p>
         * </li>
         * </ul>
         * 
         * @param sha256TreeHash
         *        For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is
         *        null.</p>
         *        <p>
         *        The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request
         *        for an archive specified a tree-hash aligned range, then this field returns a value.
         *        </p>
         *        <p>
         *        If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.
         *        </p>
         *        <p>
         *        This field is null for the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Archive retrieval jobs that specify a range that is not tree-hash aligned
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Archival jobs that specify a range that is equal to the whole archive, when the job status is
         *        <code>InProgress</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Inventory jobs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Select jobs
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha256TreeHash(String sha256TreeHash);

        /**
         * <p>
         * The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select jobs,
         * this field is null.
         * </p>
         * 
         * @param archiveSHA256TreeHash
         *        The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select
         *        jobs, this field is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveSHA256TreeHash(String archiveSHA256TreeHash);

        /**
         * <p>
         * The retrieved byte range for archive retrieval jobs in the form <i>StartByteValue</i>-<i>EndByteValue</i>. If
         * no range was specified in the archive retrieval, then the whole archive is retrieved. In this case,
         * <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals the size of the archive minus 1. For inventory
         * retrieval or select jobs, this field is null.
         * </p>
         * 
         * @param retrievalByteRange
         *        The retrieved byte range for archive retrieval jobs in the form
         *        <i>StartByteValue</i>-<i>EndByteValue</i>. If no range was specified in the archive retrieval, then
         *        the whole archive is retrieved. In this case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i>
         *        equals the size of the archive minus 1. For inventory retrieval or select jobs, this field is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalByteRange(String retrievalByteRange);

        /**
         * <p>
         * The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>,
         * <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
         * </p>
         * 
         * @param tier
         *        The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>,
         *        <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(String tier);

        /**
         * <p>
         * Parameters used for range inventory retrieval.
         * </p>
         * 
         * @param inventoryRetrievalParameters
         *        Parameters used for range inventory retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription inventoryRetrievalParameters);

        /**
         * <p>
         * Parameters used for range inventory retrieval.
         * </p>
         * This is a convenience that creates an instance of the {@link InventoryRetrievalJobDescription.Builder}
         * avoiding the need to create one manually via {@link InventoryRetrievalJobDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link InventoryRetrievalJobDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inventoryRetrievalParameters(InventoryRetrievalJobDescription)}.
         * 
         * @param inventoryRetrievalParameters
         *        a consumer that will call methods on {@link InventoryRetrievalJobDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inventoryRetrievalParameters(InventoryRetrievalJobDescription)
         */
        default Builder inventoryRetrievalParameters(
                Consumer<InventoryRetrievalJobDescription.Builder> inventoryRetrievalParameters) {
            return inventoryRetrievalParameters(InventoryRetrievalJobDescription.builder()
                    .applyMutation(inventoryRetrievalParameters).build());
        }

        /**
         * <p>
         * Contains the job output location.
         * </p>
         * 
         * @param jobOutputPath
         *        Contains the job output location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutputPath(String jobOutputPath);

        /**
         * <p>
         * Contains the parameters used for a select.
         * </p>
         * 
         * @param selectParameters
         *        Contains the parameters used for a select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectParameters(SelectParameters selectParameters);

        /**
         * <p>
         * Contains the parameters used for a select.
         * </p>
         * This is a convenience that creates an instance of the {@link SelectParameters.Builder} avoiding the need to
         * create one manually via {@link SelectParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelectParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #selectParameters(SelectParameters)}.
         * 
         * @param selectParameters
         *        a consumer that will call methods on {@link SelectParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectParameters(SelectParameters)
         */
        default Builder selectParameters(Consumer<SelectParameters.Builder> selectParameters) {
            return selectParameters(SelectParameters.builder().applyMutation(selectParameters).build());
        }

        /**
         * <p>
         * Contains the location where the data from the select job is stored.
         * </p>
         * 
         * @param outputLocation
         *        Contains the location where the data from the select job is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * <p>
         * Contains the location where the data from the select job is stored.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputLocation.Builder} avoiding the need to
         * create one manually via {@link OutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobDescription;

        private String action;

        private String archiveId;

        private String vaultARN;

        private String creationDate;

        private Boolean completed;

        private String statusCode;

        private String statusMessage;

        private Long archiveSizeInBytes;

        private Long inventorySizeInBytes;

        private String snsTopic;

        private String completionDate;

        private String sha256TreeHash;

        private String archiveSHA256TreeHash;

        private String retrievalByteRange;

        private String tier;

        private InventoryRetrievalJobDescription inventoryRetrievalParameters;

        private String jobOutputPath;

        private SelectParameters selectParameters;

        private OutputLocation outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GlacierJobDescription model) {
            jobId(model.jobId);
            jobDescription(model.jobDescription);
            action(model.action);
            archiveId(model.archiveId);
            vaultARN(model.vaultARN);
            creationDate(model.creationDate);
            completed(model.completed);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
            archiveSizeInBytes(model.archiveSizeInBytes);
            inventorySizeInBytes(model.inventorySizeInBytes);
            snsTopic(model.snsTopic);
            completionDate(model.completionDate);
            sha256TreeHash(model.sha256TreeHash);
            archiveSHA256TreeHash(model.archiveSHA256TreeHash);
            retrievalByteRange(model.retrievalByteRange);
            tier(model.tier);
            inventoryRetrievalParameters(model.inventoryRetrievalParameters);
            jobOutputPath(model.jobOutputPath);
            selectParameters(model.selectParameters);
            outputLocation(model.outputLocation);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobDescription() {
            return jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionCode action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getArchiveId() {
            return archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        public final String getVaultARN() {
            return vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getCompleted() {
            return completed;
        }

        @Override
        public final Builder completed(Boolean completed) {
            this.completed = completed;
            return this;
        }

        public final void setCompleted(Boolean completed) {
            this.completed = completed;
        }

        public final String getStatusCodeAsString() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(StatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Long getArchiveSizeInBytes() {
            return archiveSizeInBytes;
        }

        @Override
        public final Builder archiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
            return this;
        }

        public final void setArchiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
        }

        public final Long getInventorySizeInBytes() {
            return inventorySizeInBytes;
        }

        @Override
        public final Builder inventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
            return this;
        }

        public final void setInventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
        }

        public final String getSnsTopic() {
            return snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final String getCompletionDate() {
            return completionDate;
        }

        @Override
        public final Builder completionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(String completionDate) {
            this.completionDate = completionDate;
        }

        public final String getSha256TreeHash() {
            return sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public final void setSha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        public final String getArchiveSHA256TreeHash() {
            return archiveSHA256TreeHash;
        }

        @Override
        public final Builder archiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
            return this;
        }

        public final void setArchiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
        }

        public final String getRetrievalByteRange() {
            return retrievalByteRange;
        }

        @Override
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        public final String getTier() {
            return tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final InventoryRetrievalJobDescription.Builder getInventoryRetrievalParameters() {
            return inventoryRetrievalParameters != null ? inventoryRetrievalParameters.toBuilder() : null;
        }

        @Override
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final void setInventoryRetrievalParameters(
                InventoryRetrievalJobDescription.BuilderImpl inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters != null ? inventoryRetrievalParameters.build()
                    : null;
        }

        public final String getJobOutputPath() {
            return jobOutputPath;
        }

        @Override
        public final Builder jobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
            return this;
        }

        public final void setJobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
        }

        public final SelectParameters.Builder getSelectParameters() {
            return selectParameters != null ? selectParameters.toBuilder() : null;
        }

        @Override
        public final Builder selectParameters(SelectParameters selectParameters) {
            this.selectParameters = selectParameters;
            return this;
        }

        public final void setSelectParameters(SelectParameters.BuilderImpl selectParameters) {
            this.selectParameters = selectParameters != null ? selectParameters.build() : null;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public GlacierJobDescription build() {
            return new GlacierJobDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
