/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output for GetVaultAccessPolicy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVaultAccessPolicyResponse extends GlacierResponse implements
        ToCopyableBuilder<GetVaultAccessPolicyResponse.Builder, GetVaultAccessPolicyResponse> {
    private static final SdkField<VaultAccessPolicy> POLICY_FIELD = SdkField
            .<VaultAccessPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetVaultAccessPolicyResponse::policy))
            .setter(setter(Builder::policy))
            .constructor(VaultAccessPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD));

    private final VaultAccessPolicy policy;

    private GetVaultAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
    }

    /**
     * <p>
     * Contains the returned vault access policy as a JSON string.
     * </p>
     * 
     * @return Contains the returned vault access policy as a JSON string.
     */
    public VaultAccessPolicy policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVaultAccessPolicyResponse)) {
            return false;
        }
        GetVaultAccessPolicyResponse other = (GetVaultAccessPolicyResponse) obj;
        return Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetVaultAccessPolicyResponse").add("Policy", policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVaultAccessPolicyResponse, T> g) {
        return obj -> g.apply((GetVaultAccessPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVaultAccessPolicyResponse> {
        /**
         * <p>
         * Contains the returned vault access policy as a JSON string.
         * </p>
         * 
         * @param policy
         *        Contains the returned vault access policy as a JSON string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(VaultAccessPolicy policy);

        /**
         * <p>
         * Contains the returned vault access policy as a JSON string.
         * </p>
         * This is a convenience that creates an instance of the {@link VaultAccessPolicy.Builder} avoiding the need to
         * create one manually via {@link VaultAccessPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link VaultAccessPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #policy(VaultAccessPolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link VaultAccessPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(VaultAccessPolicy)
         */
        default Builder policy(Consumer<VaultAccessPolicy.Builder> policy) {
            return policy(VaultAccessPolicy.builder().applyMutation(policy).build());
        }
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private VaultAccessPolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVaultAccessPolicyResponse model) {
            super(model);
            policy(model.policy);
        }

        public final VaultAccessPolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        @Override
        public final Builder policy(VaultAccessPolicy policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(VaultAccessPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public GetVaultAccessPolicyResponse build() {
            return new GetVaultAccessPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
