/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadArchiveRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, UploadArchiveRequest> {
    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadArchiveRequest.getter(UploadArchiveRequest::vaultName)).setter(UploadArchiveRequest.setter(Builder::vaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vaultName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadArchiveRequest.getter(UploadArchiveRequest::accountId)).setter(UploadArchiveRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(), DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())}).build();
    private static final SdkField<String> ARCHIVE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadArchiveRequest.getter(UploadArchiveRequest::archiveDescription)).setter(UploadArchiveRequest.setter(Builder::archiveDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-archive-description").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UploadArchiveRequest.getter(UploadArchiveRequest::checksum)).setter(UploadArchiveRequest.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-sha256-tree-hash").build()}).build();
    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UploadArchiveRequest.getter(UploadArchiveRequest::contentLength)).setter(UploadArchiveRequest.setter(Builder::contentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_NAME_FIELD, ACCOUNT_ID_FIELD, ARCHIVE_DESCRIPTION_FIELD, CHECKSUM_FIELD, CONTENT_LENGTH_FIELD));
    private final String vaultName;
    private final String accountId;
    private final String archiveDescription;
    private final String checksum;
    private final Long contentLength;

    private UploadArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.vaultName = builder.vaultName;
        this.accountId = builder.accountId;
        this.archiveDescription = builder.archiveDescription;
        this.checksum = builder.checksum;
        this.contentLength = builder.contentLength;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String accountId() {
        return this.accountId;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public String checksum() {
        return this.checksum;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadArchiveRequest)) {
            return false;
        }
        UploadArchiveRequest other = (UploadArchiveRequest)((Object)obj);
        return Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.archiveDescription(), other.archiveDescription()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.contentLength(), other.contentLength());
    }

    public String toString() {
        return ToString.builder((String)"UploadArchiveRequest").add("VaultName", (Object)this.vaultName()).add("AccountId", (Object)this.accountId()).add("ArchiveDescription", (Object)this.archiveDescription()).add("Checksum", (Object)this.checksum()).add("ContentLength", (Object)this.contentLength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vaultName": {
                return Optional.ofNullable(clazz.cast(this.vaultName()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "archiveDescription": {
                return Optional.ofNullable(clazz.cast(this.archiveDescription()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "ContentLength": {
                return Optional.ofNullable(clazz.cast(this.contentLength()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadArchiveRequest, T> g) {
        return obj -> g.apply((UploadArchiveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String vaultName;
        private String accountId;
        private String archiveDescription;
        private String checksum;
        private Long contentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadArchiveRequest model) {
            super(model);
            this.vaultName(model.vaultName);
            this.accountId(model.accountId);
            this.archiveDescription(model.archiveDescription);
            this.checksum(model.checksum);
            this.contentLength(model.contentLength);
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadArchiveRequest build() {
            return new UploadArchiveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UploadArchiveRequest> {
        public Builder vaultName(String var1);

        public Builder accountId(String var1);

        public Builder archiveDescription(String var1);

        public Builder checksum(String var1);

        public Builder contentLength(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

