/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

public class ListMultipartUploadsPublisher
implements SdkPublisher<ListMultipartUploadsResponse> {
    private final GlacierAsyncClient client;
    private final ListMultipartUploadsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMultipartUploadsPublisher(GlacierAsyncClient client, ListMultipartUploadsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMultipartUploadsPublisher(GlacierAsyncClient client, ListMultipartUploadsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMultipartUploadsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMultipartUploadsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<UploadListElement> uploadsList() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploadsList() != null) {
                return response.uploadsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListMultipartUploadsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListMultipartUploadsPublisher resume(ListMultipartUploadsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMultipartUploadsPublisher(this.client, (ListMultipartUploadsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListMultipartUploadsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListMultipartUploadsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListMultipartUploadsResponseFetcher
    implements AsyncPageFetcher<ListMultipartUploadsResponse> {
        private ListMultipartUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartUploadsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<ListMultipartUploadsResponse> nextPage(ListMultipartUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartUploadsPublisher.this.client.listMultipartUploads(ListMultipartUploadsPublisher.this.firstRequest);
            }
            return ListMultipartUploadsPublisher.this.client.listMultipartUploads((ListMultipartUploadsRequest)((Object)ListMultipartUploadsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

