/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.NotificationEventListCopier;
import software.amazon.awssdk.services.glacier.transform.VaultNotificationConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VaultNotificationConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, VaultNotificationConfig> {
    private final String snsTopic;
    private final List<String> events;

    private VaultNotificationConfig(BuilderImpl builder) {
        this.snsTopic = builder.snsTopic;
        this.events = builder.events;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public List<String> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaultNotificationConfig)) {
            return false;
        }
        VaultNotificationConfig other = (VaultNotificationConfig)obj;
        return Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"VaultNotificationConfig").add("SNSTopic", (Object)this.snsTopic()).add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SNSTopic": {
                return Optional.of(clazz.cast(this.snsTopic()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VaultNotificationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String snsTopic;
        private List<String> events;

        private BuilderImpl() {
        }

        private BuilderImpl(VaultNotificationConfig model) {
            this.snsTopic(model.snsTopic);
            this.events(model.events);
        }

        public final String getSNSTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSNSTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = NotificationEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = NotificationEventListCopier.copy(events);
        }

        public VaultNotificationConfig build() {
            return new VaultNotificationConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VaultNotificationConfig> {
        public Builder snsTopic(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);
    }
}

