/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

@SdkInternalApi
public class UploadListElementMarshaller {
    private static final MarshallingInfo<String> MULTIPARTUPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultipartUploadId").build();
    private static final MarshallingInfo<String> VAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultARN").build();
    private static final MarshallingInfo<String> ARCHIVEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveDescription").build();
    private static final MarshallingInfo<Long> PARTSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartSizeInBytes").build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final UploadListElementMarshaller INSTANCE = new UploadListElementMarshaller();

    public static UploadListElementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UploadListElement uploadListElement, ProtocolMarshaller protocolMarshaller) {
        if (uploadListElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)uploadListElement.multipartUploadId(), MULTIPARTUPLOADID_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.vaultARN(), VAULTARN_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.archiveDescription(), ARCHIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.partSizeInBytes(), PARTSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

