/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.GlacierJobDescription;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;

public final class ListJobsPaginator
implements SdkIterable<ListJobsResponse> {
    private final GlacierClient client;
    private final ListJobsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListJobsPaginator(GlacierClient client, ListJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public Iterator<ListJobsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<GlacierJobDescription> jobList() {
        Function<ListJobsResponse, Iterator> getIterator = response -> response != null ? response.jobList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListJobsResponseFetcher
    implements NextPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListJobsResponse nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsPaginator.this.client.listJobs(ListJobsPaginator.this.firstRequest);
            }
            return ListJobsPaginator.this.client.listJobs((ListJobsRequest)((Object)ListJobsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

