/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InitiateMultipartUploadRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, InitiateMultipartUploadRequest> {
    private final String accountId;
    private final String vaultName;
    private final String archiveDescription;
    private final String partSize;

    private InitiateMultipartUploadRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.archiveDescription = builder.archiveDescription;
        this.partSize = builder.partSize;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public String partSize() {
        return this.partSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateMultipartUploadRequest)) {
            return false;
        }
        InitiateMultipartUploadRequest other = (InitiateMultipartUploadRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.archiveDescription(), other.archiveDescription()) && Objects.equals(this.partSize(), other.partSize());
    }

    public String toString() {
        return ToString.builder((String)"InitiateMultipartUploadRequest").add("AccountId", (Object)this.accountId()).add("VaultName", (Object)this.vaultName()).add("ArchiveDescription", (Object)this.archiveDescription()).add("PartSize", (Object)this.partSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "vaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "archiveDescription": {
                return Optional.of(clazz.cast(this.archiveDescription()));
            }
            case "partSize": {
                return Optional.of(clazz.cast(this.partSize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String archiveDescription;
        private String partSize;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateMultipartUploadRequest model) {
            this.accountId(model.accountId);
            this.vaultName(model.vaultName);
            this.archiveDescription(model.archiveDescription);
            this.partSize(model.partSize);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final String getPartSize() {
            return this.partSize;
        }

        @Override
        public final Builder partSize(String partSize) {
            this.partSize = partSize;
            return this;
        }

        public final void setPartSize(String partSize) {
            this.partSize = partSize;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public InitiateMultipartUploadRequest build() {
            return new InitiateMultipartUploadRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, InitiateMultipartUploadRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder archiveDescription(String var1);

        public Builder partSize(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

