/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glacier.model.GlacierRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadArchiveRequest
extends GlacierRequest
implements ToCopyableBuilder<Builder, UploadArchiveRequest> {
    private final String vaultName;
    private final String accountId;
    private final String archiveDescription;
    private final String checksum;
    private final Long contentLength;

    private UploadArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.vaultName = builder.vaultName;
        this.accountId = builder.accountId;
        this.archiveDescription = builder.archiveDescription;
        this.checksum = builder.checksum;
        this.contentLength = builder.contentLength;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String accountId() {
        return this.accountId;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public String checksum() {
        return this.checksum;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadArchiveRequest)) {
            return false;
        }
        UploadArchiveRequest other = (UploadArchiveRequest)((Object)obj);
        return Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.archiveDescription(), other.archiveDescription()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.contentLength(), other.contentLength());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.archiveDescription() != null) {
            sb.append("ArchiveDescription: ").append(this.archiveDescription()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.contentLength() != null) {
            sb.append("ContentLength: ").append(this.contentLength()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "archiveDescription": {
                return Optional.of(clazz.cast(this.archiveDescription()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "ContentLength": {
                return Optional.of(clazz.cast(this.contentLength()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierRequest.BuilderImpl
    implements Builder {
        private String vaultName;
        private String accountId;
        private String archiveDescription;
        private String checksum;
        private Long contentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadArchiveRequest model) {
            this.vaultName(model.vaultName);
            this.accountId(model.accountId);
            this.archiveDescription(model.archiveDescription);
            this.checksum(model.checksum);
            this.contentLength(model.contentLength);
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UploadArchiveRequest build() {
            return new UploadArchiveRequest(this);
        }
    }

    public static interface Builder
    extends GlacierRequest.Builder,
    CopyableBuilder<Builder, UploadArchiveRequest> {
        public Builder vaultName(String var1);

        public Builder accountId(String var1);

        public Builder archiveDescription(String var1);

        public Builder checksum(String var1);

        public Builder contentLength(Long var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

