/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InitiateMultipartUploadResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, InitiateMultipartUploadResponse> {
    private final String location;
    private final String uploadId;

    private InitiateMultipartUploadResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.uploadId = builder.uploadId;
    }

    public String location() {
        return this.location;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateMultipartUploadResponse)) {
            return false;
        }
        InitiateMultipartUploadResponse other = (InitiateMultipartUploadResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.uploadId(), other.uploadId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "uploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String location;
        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateMultipartUploadResponse model) {
            this.location(model.location);
            this.uploadId(model.uploadId);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public InitiateMultipartUploadResponse build() {
            return new InitiateMultipartUploadResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, InitiateMultipartUploadResponse> {
        public Builder location(String var1);

        public Builder uploadId(String var1);
    }
}

