/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InitiateJobResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, InitiateJobResponse> {
    private final String location;
    private final String jobId;

    private InitiateJobResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.jobId = builder.jobId;
    }

    public String location() {
        return this.location;
    }

    public String jobId() {
        return this.jobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateJobResponse)) {
            return false;
        }
        InitiateJobResponse other = (InitiateJobResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.jobId(), other.jobId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String location;
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateJobResponse model) {
            this.location(model.location);
            this.jobId(model.jobId);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public InitiateJobResponse build() {
            return new InitiateJobResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, InitiateJobResponse> {
        public Builder location(String var1);

        public Builder jobId(String var1);
    }
}

