/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.PartListElement;

@SdkInternalApi
public class PartListElementMarshaller {
    private static final MarshallingInfo<String> RANGEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RangeInBytes").build();
    private static final MarshallingInfo<String> SHA256TREEHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SHA256TreeHash").build();
    private static final PartListElementMarshaller INSTANCE = new PartListElementMarshaller();

    public static PartListElementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PartListElement partListElement, ProtocolMarshaller protocolMarshaller) {
        if (partListElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)partListElement.rangeInBytes(), RANGEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)partListElement.sha256TreeHash(), SHA256TREEHASH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

