/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput;
import software.amazon.awssdk.services.glacier.transform.JobParametersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, JobParameters> {
    private final String format;
    private final String type;
    private final String archiveId;
    private final String description;
    private final String snsTopic;
    private final String retrievalByteRange;
    private final String tier;
    private final InventoryRetrievalJobInput inventoryRetrievalParameters;

    private JobParameters(BuilderImpl builder) {
        this.format = builder.format;
        this.type = builder.type;
        this.archiveId = builder.archiveId;
        this.description = builder.description;
        this.snsTopic = builder.snsTopic;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
    }

    public String format() {
        return this.format;
    }

    public String type() {
        return this.type;
    }

    public String archiveId() {
        return this.archiveId;
    }

    public String description() {
        return this.description;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public String retrievalByteRange() {
        return this.retrievalByteRange;
    }

    public String tier() {
        return this.tier;
    }

    public InventoryRetrievalJobInput inventoryRetrievalParameters() {
        return this.inventoryRetrievalParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.archiveId() == null ? 0 : this.archiveId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.snsTopic() == null ? 0 : this.snsTopic().hashCode());
        hashCode = 31 * hashCode + (this.retrievalByteRange() == null ? 0 : this.retrievalByteRange().hashCode());
        hashCode = 31 * hashCode + (this.tier() == null ? 0 : this.tier().hashCode());
        hashCode = 31 * hashCode + (this.inventoryRetrievalParameters() == null ? 0 : this.inventoryRetrievalParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        JobParameters other = (JobParameters)obj;
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.archiveId() == null ^ this.archiveId() == null) {
            return false;
        }
        if (other.archiveId() != null && !other.archiveId().equals(this.archiveId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.snsTopic() == null ^ this.snsTopic() == null) {
            return false;
        }
        if (other.snsTopic() != null && !other.snsTopic().equals(this.snsTopic())) {
            return false;
        }
        if (other.retrievalByteRange() == null ^ this.retrievalByteRange() == null) {
            return false;
        }
        if (other.retrievalByteRange() != null && !other.retrievalByteRange().equals(this.retrievalByteRange())) {
            return false;
        }
        if (other.tier() == null ^ this.tier() == null) {
            return false;
        }
        if (other.tier() != null && !other.tier().equals(this.tier())) {
            return false;
        }
        if (other.inventoryRetrievalParameters() == null ^ this.inventoryRetrievalParameters() == null) {
            return false;
        }
        return other.inventoryRetrievalParameters() == null || other.inventoryRetrievalParameters().equals(this.inventoryRetrievalParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.archiveId() != null) {
            sb.append("ArchiveId: ").append(this.archiveId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.snsTopic() != null) {
            sb.append("SNSTopic: ").append(this.snsTopic()).append(",");
        }
        if (this.retrievalByteRange() != null) {
            sb.append("RetrievalByteRange: ").append(this.retrievalByteRange()).append(",");
        }
        if (this.tier() != null) {
            sb.append("Tier: ").append(this.tier()).append(",");
        }
        if (this.inventoryRetrievalParameters() != null) {
            sb.append("InventoryRetrievalParameters: ").append(this.inventoryRetrievalParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.of(clazz.cast(this.format()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "ArchiveId": {
                return Optional.of(clazz.cast(this.archiveId()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "SNSTopic": {
                return Optional.of(clazz.cast(this.snsTopic()));
            }
            case "RetrievalByteRange": {
                return Optional.of(clazz.cast(this.retrievalByteRange()));
            }
            case "Tier": {
                return Optional.of(clazz.cast(this.tier()));
            }
            case "InventoryRetrievalParameters": {
                return Optional.of(clazz.cast(this.inventoryRetrievalParameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String type;
        private String archiveId;
        private String description;
        private String snsTopic;
        private String retrievalByteRange;
        private String tier;
        private InventoryRetrievalJobInput inventoryRetrievalParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(JobParameters model) {
            this.format(model.format);
            this.type(model.type);
            this.archiveId(model.archiveId);
            this.description(model.description);
            this.snsTopic(model.snsTopic);
            this.retrievalByteRange(model.retrievalByteRange);
            this.tier(model.tier);
            this.inventoryRetrievalParameters(model.inventoryRetrievalParameters);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSNSTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSNSTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final String getRetrievalByteRange() {
            return this.retrievalByteRange;
        }

        @Override
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        public final String getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final InventoryRetrievalJobInput.Builder getInventoryRetrievalParameters() {
            return this.inventoryRetrievalParameters != null ? this.inventoryRetrievalParameters.toBuilder() : null;
        }

        @Override
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobInput inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final void setInventoryRetrievalParameters(InventoryRetrievalJobInput.BuilderImpl inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters != null ? inventoryRetrievalParameters.build() : null;
        }

        public JobParameters build() {
            return new JobParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobParameters> {
        public Builder format(String var1);

        public Builder type(String var1);

        public Builder archiveId(String var1);

        public Builder description(String var1);

        public Builder snsTopic(String var1);

        public Builder retrievalByteRange(String var1);

        public Builder tier(String var1);

        public Builder inventoryRetrievalParameters(InventoryRetrievalJobInput var1);
    }
}

