/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.VaultAccessPolicy;

@SdkInternalApi
public class VaultAccessPolicyMarshaller {
    private static final MarshallingInfo<String> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policy").build();
    private static final VaultAccessPolicyMarshaller INSTANCE = new VaultAccessPolicyMarshaller();

    public static VaultAccessPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VaultAccessPolicy vaultAccessPolicy, ProtocolMarshaller protocolMarshaller) {
        if (vaultAccessPolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)vaultAccessPolicy.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

