/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import java.nio.file.Path;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.glacier.DefaultGlacierClientBuilder;
import software.amazon.awssdk.services.glacier.GlacierClientBuilder;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultResponse;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.CreateVaultRequest;
import software.amazon.awssdk.services.glacier.model.CreateVaultResponse;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultResponse;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobResponse;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.GlacierException;
import software.amazon.awssdk.services.glacier.model.InitiateJobRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobResponse;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.InsufficientCapacityException;
import software.amazon.awssdk.services.glacier.model.InvalidParameterValueException;
import software.amazon.awssdk.services.glacier.model.LimitExceededException;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;
import software.amazon.awssdk.services.glacier.model.MissingParameterValueException;
import software.amazon.awssdk.services.glacier.model.PolicyEnforcedException;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultResponse;
import software.amazon.awssdk.services.glacier.model.RequestTimeoutException;
import software.amazon.awssdk.services.glacier.model.ResourceNotFoundException;
import software.amazon.awssdk.services.glacier.model.ServiceUnavailableException;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse;
import software.amazon.awssdk.services.glacier.waiters.GlacierClientWaiters;
import software.amazon.awssdk.sync.RequestBody;
import software.amazon.awssdk.sync.ResponseInputStream;
import software.amazon.awssdk.sync.StreamingResponseHandler;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface GlacierClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "glacier";

    public static GlacierClient create() {
        return (GlacierClient)GlacierClient.builder().build();
    }

    public static GlacierClientBuilder builder() {
        return new DefaultGlacierClientBuilder();
    }

    default public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AbortVaultLockResponse abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public AddTagsToVaultResponse addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, LimitExceededException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CompleteVaultLockResponse completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public CreateVaultResponse createVault(CreateVaultRequest createVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteArchiveResponse deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultResponse deleteVault(DeleteVaultRequest deleteVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultAccessPolicyResponse deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVaultNotificationsResponse deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public DescribeVaultResponse describeVault(DescribeVaultRequest describeVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetDataRetrievalPolicyResponse getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getJobOutput(GetJobOutputRequest getJobOutputRequest, StreamingResponseHandler<GetJobOutputResponse, ReturnT> streamingResponseHandler) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetJobOutputResponse getJobOutput(GetJobOutputRequest getJobOutputRequest, Path filePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return (GetJobOutputResponse)((Object)this.getJobOutput(getJobOutputRequest, StreamingResponseHandler.toFile((Path)filePath)));
    }

    default public ResponseInputStream<GetJobOutputResponse> getJobOutput(GetJobOutputRequest getJobOutputRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return (ResponseInputStream)this.getJobOutput(getJobOutputRequest, StreamingResponseHandler.toInputStream());
    }

    default public GetVaultAccessPolicyResponse getVaultAccessPolicy(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultLockResponse getVaultLock(GetVaultLockRequest getVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public GetVaultNotificationsResponse getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateJobResponse initiateJob(InitiateJobRequest initiateJobRequest) throws ResourceNotFoundException, PolicyEnforcedException, InvalidParameterValueException, MissingParameterValueException, InsufficientCapacityException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateMultipartUploadResponse initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public InitiateVaultLockResponse initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListProvisionedCapacityResponse listProvisionedCapacity(ListProvisionedCapacityRequest listProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForVaultResponse listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public ListVaultsResponse listVaults(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public RemoveTagsFromVaultResponse removeTagsFromVault(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetDataRetrievalPolicyResponse setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetVaultAccessPolicyResponse setVaultAccessPolicy(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public SetVaultNotificationsResponse setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, Path filePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return this.uploadArchive(uploadArchiveRequest, RequestBody.of((Path)filePath));
    }

    default public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        throw new UnsupportedOperationException();
    }

    default public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, Path filePath) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return this.uploadMultipartPart(uploadMultipartPartRequest, RequestBody.of((Path)filePath));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }

    public GlacierClientWaiters waiters();
}

