/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.VaultLockPolicy;

@SdkInternalApi
public class VaultLockPolicyMarshaller {
    private static final MarshallingInfo<String> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policy").build();
    private static final VaultLockPolicyMarshaller INSTANCE = new VaultLockPolicyMarshaller();

    public static VaultLockPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VaultLockPolicy vaultLockPolicy, ProtocolMarshaller protocolMarshaller) {
        if (vaultLockPolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)vaultLockPolicy.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

