/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;

public class UploadArchiveResponseUnmarshaller
implements Unmarshaller<UploadArchiveResponse, JsonUnmarshallerContext> {
    private static final UploadArchiveResponseUnmarshaller INSTANCE = new UploadArchiveResponseUnmarshaller();

    public UploadArchiveResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UploadArchiveResponse.Builder uploadArchiveResponseBuilder = UploadArchiveResponse.builder();
        if (context.isStartOfDocument()) {
            if (context.getHeader("Location") != null) {
                context.setCurrentHeader("Location");
                uploadArchiveResponseBuilder.location((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("x-amz-sha256-tree-hash") != null) {
                context.setCurrentHeader("x-amz-sha256-tree-hash");
                uploadArchiveResponseBuilder.checksum((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("x-amz-archive-id") != null) {
                context.setCurrentHeader("x-amz-archive-id");
                uploadArchiveResponseBuilder.archiveId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
        }
        return (UploadArchiveResponse)((Object)uploadArchiveResponseBuilder.build());
    }

    public static UploadArchiveResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

