/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.JobParameters;
import software.amazon.awssdk.services.glacier.transform.InventoryRetrievalJobInputUnmarshaller;

public class JobParametersUnmarshaller
implements Unmarshaller<JobParameters, JsonUnmarshallerContext> {
    private static final JobParametersUnmarshaller INSTANCE = new JobParametersUnmarshaller();

    public JobParameters unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobParameters.Builder jobParametersBuilder = JobParameters.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Format", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.format((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ArchiveId", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.archiveId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SNSTopic", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.snsTopic((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RetrievalByteRange", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.retrievalByteRange((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Tier", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.tier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InventoryRetrievalParameters", targetDepth)) {
                    context.nextToken();
                    jobParametersBuilder.inventoryRetrievalParameters(InventoryRetrievalJobInputUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JobParameters)jobParametersBuilder.build();
    }

    public static JobParametersUnmarshaller getInstance() {
        return INSTANCE;
    }
}

