/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.NotificationEventListCopier;
import software.amazon.awssdk.services.glacier.transform.VaultNotificationConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VaultNotificationConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, VaultNotificationConfig> {
    private final String snsTopic;
    private final List<String> events;

    private VaultNotificationConfig(BuilderImpl builder) {
        this.snsTopic = builder.snsTopic;
        this.events = builder.events;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public List<String> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snsTopic() == null ? 0 : this.snsTopic().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaultNotificationConfig)) {
            return false;
        }
        VaultNotificationConfig other = (VaultNotificationConfig)obj;
        if (other.snsTopic() == null ^ this.snsTopic() == null) {
            return false;
        }
        if (other.snsTopic() != null && !other.snsTopic().equals(this.snsTopic())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        return other.events() == null || other.events().equals(this.events());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.snsTopic() != null) {
            sb.append("SNSTopic: ").append(this.snsTopic()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VaultNotificationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String snsTopic;
        private List<String> events;

        private BuilderImpl() {
        }

        private BuilderImpl(VaultNotificationConfig model) {
            this.setSNSTopic(model.snsTopic);
            this.setEvents(model.events);
        }

        public final String getSNSTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSNSTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = NotificationEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = NotificationEventListCopier.copy(events);
        }

        public VaultNotificationConfig build() {
            return new VaultNotificationConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VaultNotificationConfig> {
        public Builder snsTopic(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);
    }
}

