/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.VaultNotificationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVaultNotificationsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, GetVaultNotificationsResponse> {
    private static final SdkField<VaultNotificationConfig> VAULT_NOTIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetVaultNotificationsResponse.getter(GetVaultNotificationsResponse::vaultNotificationConfig)).setter(GetVaultNotificationsResponse.setter(Builder::vaultNotificationConfig)).constructor(VaultNotificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vaultNotificationConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_NOTIFICATION_CONFIG_FIELD));
    private final VaultNotificationConfig vaultNotificationConfig;

    private GetVaultNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.vaultNotificationConfig = builder.vaultNotificationConfig;
    }

    public VaultNotificationConfig vaultNotificationConfig() {
        return this.vaultNotificationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultNotificationConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVaultNotificationsResponse)) {
            return false;
        }
        GetVaultNotificationsResponse other = (GetVaultNotificationsResponse)((Object)obj);
        return Objects.equals(this.vaultNotificationConfig(), other.vaultNotificationConfig());
    }

    public String toString() {
        return ToString.builder((String)"GetVaultNotificationsResponse").add("VaultNotificationConfig", (Object)this.vaultNotificationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vaultNotificationConfig": {
                return Optional.ofNullable(clazz.cast(this.vaultNotificationConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVaultNotificationsResponse, T> g) {
        return obj -> g.apply((GetVaultNotificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private VaultNotificationConfig vaultNotificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVaultNotificationsResponse model) {
            super(model);
            this.vaultNotificationConfig(model.vaultNotificationConfig);
        }

        public final VaultNotificationConfig.Builder getVaultNotificationConfig() {
            return this.vaultNotificationConfig != null ? this.vaultNotificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder vaultNotificationConfig(VaultNotificationConfig vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig;
            return this;
        }

        public final void setVaultNotificationConfig(VaultNotificationConfig.BuilderImpl vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig != null ? vaultNotificationConfig.build() : null;
        }

        @Override
        public GetVaultNotificationsResponse build() {
            return new GetVaultNotificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVaultNotificationsResponse> {
        public Builder vaultNotificationConfig(VaultNotificationConfig var1);

        default public Builder vaultNotificationConfig(Consumer<VaultNotificationConfig.Builder> vaultNotificationConfig) {
            return this.vaultNotificationConfig((VaultNotificationConfig)((VaultNotificationConfig.Builder)VaultNotificationConfig.builder().applyMutation(vaultNotificationConfig)).build());
        }
    }
}

