/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class RemoveTagsFromVaultRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<List> TAGKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKeys").build();
    private static final RemoveTagsFromVaultRequestModelMarshaller instance = new RemoveTagsFromVaultRequestModelMarshaller();

    public static RemoveTagsFromVaultRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(RemoveTagsFromVaultRequest removeTagsFromVaultRequest, ProtocolMarshaller protocolMarshaller) {
        if (removeTagsFromVaultRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)removeTagsFromVaultRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)removeTagsFromVaultRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(removeTagsFromVaultRequest.tagKeys(), TAGKEYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

